/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.algorithm.search.graph;

import eu.javaexperience.algorithm.search.graph.GraphSearchTraveledPath;
import eu.javaexperience.algorithm.search.graph.GraphSearchVertexTransition;
import eu.javaexperience.algorithm.search.graph.GraphSearcher;
import eu.javaexperience.collection.map.MultiCollectionMap;
import eu.javaexperience.graph.GraphVertexTransition;
import eu.javaexperience.interfaces.simple.SimpleGetFactory;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SimpleGraphStructure<V, E> {
    protected MultiCollectionMap<V, GraphVertexTransition<SimpleGraphStructure<V, E>, V, E>> graph = new MultiCollectionMap(new HashMap(), SimpleGetFactory.getArrayListFactory());

    public void addNode(V vertex) {
        this.graph.preserv(vertex);
    }

    public void addEdge(V from, E edge, V to) {
        this.addNode(from);
        this.addNode(to);
        GraphVertexTransition<SimpleGraphStructure, V, E> trans = new GraphVertexTransition<SimpleGraphStructure, V, E>(this, from, edge, to);
        this.graph.put((GraphVertexTransition<SimpleGraphStructure, V, E>)from, (GraphVertexTransition<SimpleGraphStructure<GraphVertexTransition<SimpleGraphStructure, V, E>, E>, GraphVertexTransition<SimpleGraphStructure, V, E>, E>)trans);
    }

    public Set<V> getVertexes() {
        return this.graph.keySet();
    }

    public Set<E> getEdges() {
        HashSet<E> ret = new HashSet<E>();
        for (Map.Entry<V, Collection<GraphVertexTransition<SimpleGraphStructure<V, E>, V, E>>> kv : this.graph.multiEntrySet()) {
            Collection<GraphVertexTransition<SimpleGraphStructure<V, E>, V, E>> val = kv.getValue();
            for (GraphVertexTransition<SimpleGraphStructure<V, E>, V, E> v : val) {
                ret.add(v.getEdge());
            }
        }
        return ret;
    }

    public Set<GraphVertexTransition<SimpleGraphStructure<V, E>, V, E>> getVertextTransitions() {
        HashSet<GraphVertexTransition<SimpleGraphStructure<V, GraphVertexTransition<SimpleGraphStructure<V, E>, V, E>>, V, GraphVertexTransition<SimpleGraphStructure<V, E>, V, E>>> ret = new HashSet<GraphVertexTransition<SimpleGraphStructure<V, GraphVertexTransition<SimpleGraphStructure<V, E>, V, E>>, V, GraphVertexTransition<SimpleGraphStructure<V, E>, V, E>>>();
        for (Map.Entry<V, Collection<GraphVertexTransition<SimpleGraphStructure<V, E>, V, E>>> kv : this.graph.multiEntrySet()) {
            V key = kv.getKey();
            Collection<GraphVertexTransition<SimpleGraphStructure<V, E>, V, E>> val = kv.getValue();
            for (GraphVertexTransition<SimpleGraphStructure<V, E>, V, E> v : val) {
                if (!v.getFrom().equals(key)) continue;
                ret.add(v);
            }
        }
        return ret;
    }

    private static String escapeString(String toEscape, String subject) {
        return subject.replace("(?!\\)" + toEscape, "\\" + toEscape);
    }

    public GraphvizDotRenderer toGraphvizRenderer(GetBy1<String, V> nodeText, GetBy1<String, E> edgeText) {
        GraphvizDotRenderer ret = new GraphvizDotRenderer();
        ret.nodeText = nodeText;
        ret.edgeText = edgeText;
        return ret;
    }

    public void toGraphviz(Appendable sb, GetBy1<String, V> nodeText) throws IOException {
        this.toGraphviz(sb, nodeText, null);
    }

    public void toGraphviz(Appendable sb, GetBy1<String, V> nodeText, GetBy1<String, E> edgeText) throws IOException {
        this.toGraphvizRenderer(nodeText, edgeText).render(sb);
    }

    public static <V, E> void addFromSearch(SimpleGraphStructure<V, E> dst, GraphSearcher<V, E> search, boolean multiPath) {
        List<GraphSearchTraveledPath<V, E>> br = search.getAllBranches();
        for (GraphSearchTraveledPath<V, E> ob : br) {
            if (!multiPath && ob.hasFork()) continue;
            for (GraphSearchVertexTransition<V, E> t : ob.getPath()) {
                dst.addEdge(t.getFrom(), t.getEdge(), t.getTo());
            }
        }
    }

    public static <V, E> SimpleGraphStructure<V, E> fromSearch(GraphSearcher<V, E> search, boolean multiPath) {
        SimpleGraphStructure<V, E> ret = new SimpleGraphStructure<V, E>();
        SimpleGraphStructure.addFromSearch(ret, search, multiPath);
        return ret;
    }

    public class GraphvizDotRenderer {
        public String defaultNodeType = "node";
        public GetBy1<String, V> nodeText;
        public GetBy1<String, E> edgeText;

        public void render(Appendable sb) throws IOException {
            sb.append("digraph structs {\n");
            sb.append("\t");
            sb.append(this.defaultNodeType);
            sb.append(" [shape=record];\n");
            Set nodes = SimpleGraphStructure.this.getVertexes();
            HashMap ids = new HashMap();
            int id = 0;
            for (Object v : nodes) {
                String add;
                ids.put(v, id);
                sb.append("\t");
                sb.append("\"");
                sb.append("id_");
                sb.append(String.valueOf(id));
                sb.append("\"");
                if (null != this.nodeText && null != (add = this.nodeText.getBy(v))) {
                    sb.append(this.renderNode(add));
                }
                sb.append("\n");
                ++id;
            }
            for (GraphVertexTransition graphVertexTransition : SimpleGraphStructure.this.getVertextTransitions()) {
                sb.append("\t\"");
                sb.append("id_");
                sb.append(String.valueOf(ids.get(graphVertexTransition.getFrom())));
                sb.append("\" -> \"");
                sb.append("id_");
                sb.append(String.valueOf(ids.get(graphVertexTransition.getTo())));
                sb.append("\"");
                if (null != this.edgeText) {
                    sb.append("[label=\"");
                    sb.append(SimpleGraphStructure.escapeString("\"", this.edgeText.getBy(graphVertexTransition.getEdge())));
                    sb.append("\"];");
                }
                sb.append("\n");
            }
            sb.append("}\n");
        }

        public String renderNode(String str) {
            return " [label=\"" + this.escape(str) + "\"]";
        }

        public String escape(String str) {
            return SimpleGraphStructure.escapeString("\"", str).replace("\n", "\\n").replace("{", "\\{").replace("}", "\\}");
        }
    }
}

