/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.algorithm.search.graph.cli;

import eu.javaexperience.algorithm.search.graph.GraphSearchAlgorithm;
import eu.javaexperience.algorithm.search.graph.GraphSearchTraveledPath;
import eu.javaexperience.algorithm.search.graph.GraphSearcher;
import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish2;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.sets.SetTools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InteractiveGraphSearchTools {
    public static <V, E> GraphSearchAlgorithm<V, E> forwardSearchUsingCliFrom(final GetBy1<String, Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>> renderOption, final BufferedReader in, final Appendable out) {
        return new GraphSearchAlgorithm<V, E>(){

            @Override
            public void initSearch(GraphSearcher<V, E> search) {
            }

            @Override
            public boolean mergeBranches(GraphSearcher<V, E> search, List<Map.Entry<GraphSearchTraveledPath<V, E>, GraphSearchTraveledPath<V, E>>> mergePairs) {
                return false;
            }

            protected Set<Integer> promptIndexes(String text, int length) throws IOException {
                out.append(text);
                String line = in.readLine();
                HashSet<Integer> ret = new HashSet<Integer>();
                try {
                    String[] nums;
                    for (String num : nums = line.split(",")) {
                        if ((num = num.trim()).length() <= 0) continue;
                        ret.add(Integer.parseInt(num.trim()));
                    }
                }
                catch (Exception e) {
                    out.append(e.getMessage());
                    return null;
                }
                return ret;
            }

            @Override
            public void extendSearchFront(GraphSearcher<V, E> search, List<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>> possibleExtends, Collection<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>> selectedExtends, Collection<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>> closedExtends) {
                try {
                    Set<Integer> close;
                    Set<Integer> open;
                    while (true) {
                        int i = 0;
                        for (Map.Entry ex : possibleExtends) {
                            out.append(i++ + ") " + (String)renderOption.getBy(ex));
                            out.append("\n");
                        }
                        open = this.promptIndexes("States to open: ", possibleExtends.size());
                        if (null == open || null == (close = this.promptIndexes("States to close: ", possibleExtends.size()))) continue;
                        HashSet<Integer> match = SetTools.diffInplace(open, close);
                        if (match.isEmpty()) break;
                        out.append("Options spcified both open and close: " + CollectionTools.toString(match) + " (Try again)");
                    }
                    for (int i = 0; i < possibleExtends.size(); ++i) {
                        if (open.contains(i)) {
                            selectedExtends.add(possibleExtends.get(i));
                        }
                        if (!close.contains(i)) continue;
                        closedExtends.add(possibleExtends.get(i));
                    }
                }
                catch (Exception e) {
                    Mirror.propagateAnyway(e);
                }
            }
        };
    }

    public static <V, E> GraphSearchAlgorithm<V, E> hookExtendsSearchFront(final GraphSearchAlgorithm<V, E> original, final SimplePublish2<Boolean, GraphSearcher<V, E>> hook_trueBefore_falseAfter) {
        return new GraphSearchAlgorithm<V, E>(){

            @Override
            public void initSearch(GraphSearcher<V, E> search) {
                original.initSearch(search);
            }

            @Override
            public boolean mergeBranches(GraphSearcher<V, E> search, List<Map.Entry<GraphSearchTraveledPath<V, E>, GraphSearchTraveledPath<V, E>>> mergePairs) {
                return original.mergeBranches(search, mergePairs);
            }

            @Override
            public void extendSearchFront(GraphSearcher<V, E> search, List<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>> possibleExtends, Collection<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>> selectedExtends, Collection<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>> closedExtends) {
                hook_trueBefore_falseAfter.publish(Boolean.TRUE, search);
                original.extendSearchFront(search, possibleExtends, selectedExtends, closedExtends);
                hook_trueBefore_falseAfter.publish(Boolean.FALSE, search);
            }
        };
    }

    public static <V, E> GraphSearchAlgorithm<V, E> forwardSearchUsingCliStdio(GetBy1<String, Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>> renderOption) {
        return InteractiveGraphSearchTools.forwardSearchUsingCliFrom(renderOption, new BufferedReader(new InputStreamReader(System.in)), System.out);
    }
}

