/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.cli;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.cli.CliTools;
import eu.javaexperience.exceptions.CheckedIllegalArgumentException;
import java.util.List;
import java.util.Map;

public class ParsedCliOptions {
    protected Map<String, List<String>> opts;

    public ParsedCliOptions(Map<String, List<String>> opts) {
        this.opts = opts;
        AssertArgument.assertNotNull(this.opts, "cli_options");
    }

    public boolean hasOptionAnyOf(String ... opt) {
        for (String s : opt) {
            if (!this.opts.containsKey(s)) continue;
            return true;
        }
        return false;
    }

    public boolean hasOption(String opt) {
        return this.opts.containsKey(opt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<String>> kv : this.opts.entrySet()) {
            sb.append("-");
            sb.append(kv.getKey());
            sb.append(" ");
            for (String s : kv.getValue()) {
                sb.append(s);
                sb.append(" ");
            }
        }
        return sb.toString();
    }

    public static ParsedCliOptions parse(String ... opts) throws CheckedIllegalArgumentException {
        return new ParsedCliOptions(CliTools.parseCliOpts(opts));
    }

    public String getFirstOptMatch(String ... keys) {
        for (String s : keys) {
            if (!this.opts.containsKey(s)) continue;
            return s;
        }
        return null;
    }

    public List<String> getOptArguments(String key) {
        return this.opts.get(key);
    }

    public Map<String, List<String>> getMap() {
        return this.opts;
    }
}

