/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.collection;

import eu.javaexperience.collection.CollectionReadOnlyFunctions;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ReadOnlyAndRwCollection<C extends Collection<?>> {
    protected C writeable;
    protected C readOnly;

    public ReadOnlyAndRwCollection(C coll, GetBy1<C, C> makeReadOnly) {
        this.writeable = coll;
        this.readOnly = (Collection)makeReadOnly.getBy(this.writeable);
    }

    public C getWriteable() {
        return this.writeable;
    }

    public C getReadOnly() {
        return this.readOnly;
    }

    public static <T> ReadOnlyAndRwCollection<List<T>> createList() {
        return new ReadOnlyAndRwCollection<List<T>>(new ArrayList(), CollectionReadOnlyFunctions.MAKE_LIST_READ_ONLY);
    }

    public static <T> ReadOnlyAndRwCollection<Set<T>> createSet() {
        return new ReadOnlyAndRwCollection<Set<T>>(new HashSet(), CollectionReadOnlyFunctions.MAKE_SET_READ_ONLY);
    }
}

