/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.collection.enumerations;

import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.collection.enumerations.EnumLike;
import eu.javaexperience.collection.enumerations.EnumManager;
import eu.javaexperience.collection.enumerations.SimpleEnumManager;
import eu.javaexperience.collection.enumerations.SimpleFixedEnumManager;
import eu.javaexperience.collection.list.NullList;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.reflect.CastTo;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EnumTools {
    public static final SimpleFixedEnumManager EMPTY_ENUM_MANAGER = new SimpleFixedEnumManager(NullList.instance);

    public static <E extends Enum<?>> boolean isSet(int num, E elem) {
        int bit = 1 << elem.ordinal();
        return (num & bit) == bit;
    }

    public static <E extends Enum<?>> boolean isSet(int num, int check) {
        return (num & check) == check;
    }

    public static <E extends Enum<?>> boolean isAllSet(int num, E ... elems) {
        int bit = 0;
        for (E e : elems) {
            bit |= 1 << ((Enum)e).ordinal();
        }
        return (num & bit) == bit;
    }

    public static <E extends Enum<?>> int setBit(int num, E elem) {
        return num | 1 << elem.ordinal();
    }

    public static <E extends Enum<?>> int resetBit(int num, E elem) {
        return num & ~(1 << elem.ordinal());
    }

    public static <E extends Enum<?>> int setBitValue(int num, E elem, boolean set) {
        if (set) {
            return EnumTools.setBit(num, elem);
        }
        return EnumTools.resetBit(num, elem);
    }

    public static <E extends Enum<?>> E getRandomEnum(Class<E> cls) {
        Enum[] es = (Enum[])cls.getEnumConstants();
        return (E)es[(int)(Math.random() * (double)es.length - 1.0)];
    }

    public static <E extends Enum<?>> int assembleLeastOne(E elem, E ... values) {
        int ret = 1 << elem.ordinal();
        for (E i : values) {
            ret |= 1 << ((Enum)i).ordinal();
        }
        return ret;
    }

    public static <E extends Enum<?>> int assemble(E ... values) {
        int ret = 0;
        for (E i : values) {
            ret |= 1 << ((Enum)i).ordinal();
        }
        return ret;
    }

    public static <E extends Enum<E>> String[] getNames(Class<E> cls) {
        Enum[] e = (Enum[])cls.getEnumConstants();
        String[] ret = new String[e.length];
        for (int i = 0; i < e.length; ++i) {
            ret[i] = e[i].name();
        }
        return ret;
    }

    public static <E extends Enum<E>> void getNames(Collection<String> dst, Class<E> cls) {
        for (Enum e : (Enum[])cls.getEnumConstants()) {
            dst.add(e.name());
        }
    }

    public static <E extends Enum<E>> Enum<E> getByName(Class<E> cls, String str) {
        Enum[] ret = (Enum[])cls.getEnumConstants();
        if (null != ret) {
            for (Enum e : ret) {
                if (!e.name().equals(str)) continue;
                return e;
            }
        }
        return null;
    }

    public static <E extends Enum<E>, L extends EnumLike<L>> EnumManager<L> createFromEnumClass(final Class<E> cls) {
        ArrayList<1> values = new ArrayList<1>();
        final HashMap<String, 1> byName = new HashMap<String, 1>();
        final EnumManager[] BIND_LATER = new EnumManager[1];
        Enum[] enumArray = (Enum[])cls.getEnumConstants();
        int n = enumArray.length;
        for (int i = 0; i < n; ++i) {
            Enum val;
            final Enum c = val = enumArray[i];
            EnumLike instance = new EnumLike<L>(){

                @Override
                public boolean isRegistered() {
                    return true;
                }

                @Override
                public String getName() {
                    return c.name();
                }

                @Override
                public int getOrdinal() {
                    return c.ordinal();
                }

                @Override
                public EnumManager<L> getEnumManager() {
                    return BIND_LATER[0];
                }

                @Override
                public void setEnumManager(EnumManager<L> mngr) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void setOrdinal(int oridinal) {
                    throw new UnsupportedOperationException();
                }
            };
            byName.put(val.name(), instance);
            values.add(instance);
        }
        final List cnst = Collections.unmodifiableList(values);
        return new EnumManager<L>(){
            {
                BIND_LATER[0] = this;
            }

            @Override
            public Iterator<L> iterator() {
                return cnst.iterator();
            }

            @Override
            public void registerElement(L elem) {
                throw new UnsupportedOperationException();
            }

            @Override
            public L getByOrdinal(int ord) {
                return (EnumLike)cnst.get(ord);
            }

            @Override
            public L getByName(String name) {
                return (EnumLike)byName.get(name);
            }

            @Override
            public Object[] getValues() {
                return cnst.toArray();
            }

            @Override
            public L[] getValues(L[] arr) {
                return (EnumLike[])cnst.toArray(arr);
            }

            @Override
            public List<L> getValueList() {
                return cnst;
            }

            public String toString() {
                return "EnumManager for enum class: " + cls;
            }
        };
    }

    public static <E extends EnumLike<E>> EnumManager<E> createFromCompatibleEnumClass(Class<E> cls) {
        return new SimpleFixedEnumManager(CollectionTools.inlineAdd(new ArrayList(), cls.getEnumConstants()));
    }

    public static <E extends EnumLike<E>> EnumManager<E> createFromEnumLikes(E ... elems) {
        SimpleEnumManager<E> ret = new SimpleEnumManager<E>();
        for (E e : elems) {
            ret.registerElement(e);
        }
        return ret;
    }

    public static <C> C recogniseSymbol(Class<C> enumClass, Object ident) {
        if (null == ident) {
            return null;
        }
        Integer NUM = (Integer)CastTo.Int.cast(ident);
        int id = -1;
        if (null != NUM) {
            id = NUM;
        }
        String str = (String)CastTo.String.cast(ident);
        for (C o : enumClass.getEnumConstants()) {
            Enum ee = (Enum)o;
            if (id != ee.ordinal() && !str.equals(ee.name())) continue;
            return (C)ee;
        }
        return null;
    }

    public static <E extends Enum> void recogniseSymbols(Class<E> enumClass, Collection<String> keys, Collection<E> dst) {
        for (String s : keys) {
            Enum val = (Enum)EnumTools.recogniseSymbol(enumClass, s);
            if (null == val) continue;
            dst.add(val);
        }
    }

    public static <T extends Enum<T>> GetBy1<T, Object> createParserFunction(final Class<T> enumClass) {
        return new GetBy1<T, Object>(){

            @Override
            public T getBy(Object a) {
                return (Enum)EnumTools.recogniseSymbol(enumClass, a);
            }
        };
    }

    public static <E extends Enum, M extends Map<String, E>> M mapByName(M dst, Class<E> enum_) {
        for (Enum e : (Enum[])enum_.getEnumConstants()) {
            dst.put((String)e.name(), (Enum)e);
        }
        return dst;
    }

    public static <T extends Enum<T>> Number enumSetBits(Class<T> cls, EnumSet<T> enumSet) {
        Enum[] vals = (Enum[])cls.getEnumConstants();
        if (vals.length > 64) {
            BigInteger in = BigInteger.ZERO;
            for (Enum e : enumSet) {
                in = in.setBit(e.ordinal());
            }
            return in;
        }
        if (vals.length > 32) {
            long ret = 0L;
            for (Enum e : enumSet) {
                ret |= (long)(1 << e.ordinal());
            }
            return ret;
        }
        int ret = 0;
        for (Enum e : enumSet) {
            ret |= 1 << e.ordinal();
        }
        return ret;
    }

    public static <T extends Enum<T>> EnumSet<T> enumSetBits(Class<T> cls, Number num) {
        EnumSet<T> ret = EnumSet.noneOf(cls);
        Enum[] vals = (Enum[])cls.getEnumConstants();
        if (num instanceof BigInteger) {
            BigInteger in = (BigInteger)num;
            for (Enum e : vals) {
                if (!in.testBit(e.ordinal())) continue;
                ret.add(e);
            }
            return ret;
        }
        long val = num.longValue();
        for (Enum e : vals) {
            if ((val & 1L << e.ordinal()) == 0L) continue;
            ret.add(e);
        }
        return ret;
    }
}

