/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.collection.enumerations;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.collection.enumerations.EnumLike;
import eu.javaexperience.collection.enumerations.EnumManager;

public class SimpleEnumLike<E extends EnumLike<E>>
implements EnumLike<E> {
    protected int ordinal = -1;
    protected String name;
    protected EnumManager<E> mngr;

    public SimpleEnumLike(String name) {
        this.name = name;
        AssertArgument.assertNotNull(this.name, "enum value name");
    }

    @Override
    public boolean isRegistered() {
        return this.ordinal >= 0;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public EnumManager<E> getEnumManager() {
        return this.mngr;
    }

    public void assertNotRegistered() {
        AssertArgument.assertTrue(null == this.mngr, "Enum's manager may be set only once. " + this.name);
    }

    @Override
    public void setEnumManager(EnumManager<E> mngr) {
        this.assertNotRegistered();
        AssertArgument.assertNotNull(mngr, "enum manager");
        this.mngr = mngr;
    }

    @Override
    public void setOrdinal(int oridinal) {
        AssertArgument.assertTrue(this.ordinal == -1, "Ordinal may be set only once.");
        AssertArgument.assertTrue(oridinal >= 0, "Ordinal must be greater than or equals 0");
        this.ordinal = oridinal;
    }
}

