/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.collection.map;

import eu.javaexperience.collection.map.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ChainedMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    protected Map<K, V>[] backs;

    public ChainedMap(Map<K, V> ... maps) {
        this.backs = maps;
    }

    @Override
    public boolean containsKey(Object key) {
        for (Map<K, V> m : this.backs) {
            if (!m.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map<K, V> m : this.backs) {
            if (!m.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        for (Map<K, V> m : this.backs) {
            V ret = m.get(key);
            if (null == ret) continue;
            return ret;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        return this.backs[0].put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.backs[0].remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.backs[0].put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.backs[0].clear();
    }

    @Override
    public Set<K> keySet() {
        HashSet<K> keys = new HashSet<K>();
        for (Map<K, V> m : this.backs) {
            keys.addAll(m.keySet());
        }
        return keys;
    }
}

