/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.collection.map;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class ConcurrentNullAcceptHashMap<K, V>
extends ConcurrentHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    AtomicReference<V> forNull = new AtomicReference();

    @Override
    public V get(Object key) {
        if (key == null) {
            return this.forNull.get();
        }
        return super.get(key);
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            V ret = this.forNull.get();
            this.forNull.set(value);
            return ret;
        }
        return super.put(key, value);
    }

    @Override
    public V putIfAbsent(K key, V fmm) {
        if (key == null) {
            V ret = this.forNull.get();
            if (ret == null) {
                this.forNull.set(fmm);
                return null;
            }
            return ret;
        }
        return super.putIfAbsent(key, fmm);
    }

    @Override
    public boolean remove(Object k, Object v) {
        if (k == null) {
            return this.forNull.compareAndSet(v, null);
        }
        return super.remove(k, v);
    }

    @Override
    public boolean replace(K k, V vo, V vn) {
        if (k == null) {
            return this.forNull.compareAndSet(vo, vn);
        }
        return super.replace(k, vo, vn);
    }

    @Override
    public V replace(K k, V v) {
        if (k == null) {
            V ret;
            do {
                if ((ret = this.forNull.get()) != null) continue;
                return null;
            } while (!this.forNull.compareAndSet(ret, v));
            return ret;
        }
        return super.replace(k, v);
    }
}

