/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.collection.map;

import eu.javaexperience.collection.map.KeyVal;
import java.io.Serializable;
import java.util.Map;

public class ImmutableKeyVal<K, V>
implements Map.Entry<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    final K k;
    final V v;
    private volatile transient int hash = 0;

    public ImmutableKeyVal(K k, V v) {
        this.k = k;
        this.v = v;
    }

    public KeyVal<K, V> clone() {
        return new KeyVal<K, V>(this.k, this.v);
    }

    public String toString() {
        return "{\"" + this.k + "\":\"" + this.v + "\"}";
    }

    @Override
    public K getKey() {
        return this.k;
    }

    @Override
    public V getValue() {
        return this.v;
    }

    public boolean isYourKeyValPar(K key, V val) {
        if (this.k != null && !this.k.equals(key)) {
            return false;
        }
        return this.v == null || this.v.equals(val);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        Map.Entry test = (Map.Entry)o;
        if (this.k != null ? !this.k.equals(test.getKey()) : test.getKey() != null) {
            return false;
        }
        return !(this.v != null ? !this.v.equals(test.getValue()) : test.getKey() != null);
    }

    @Override
    public int hashCode() {
        int ret = this.hash;
        if (ret == 0) {
            ret = 17;
            if (this.k != null) {
                ret = 31 * ret + this.k.hashCode();
            }
            if (this.v != null) {
                ret = 31 * ret + this.v.hashCode();
            }
            this.hash = ret;
        }
        return ret;
    }

    @Override
    public V setValue(V value) {
        throw new IllegalArgumentException("Modifying ImmutableKeyVal is not permitted!");
    }
}

