/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.collection.map;

import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.interfaces.simple.SimpleGetFactory;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MapTools {
    private static Comparator<Map.Entry<? extends Comparable, ?>> comparatorByKey = new Comparator<Map.Entry<? extends Comparable, ?>>(){

        @Override
        public int compare(Map.Entry<? extends Comparable, ?> arg0, Map.Entry<? extends Comparable, ?> arg1) {
            return arg0.getKey().compareTo(arg1.getKey());
        }
    };
    private static Comparator<Map.Entry<?, ? extends Comparable>> comparatorByVal = new Comparator<Map.Entry<?, ? extends Comparable>>(){

        @Override
        public int compare(Map.Entry<?, ? extends Comparable> arg0, Map.Entry<?, ? extends Comparable> arg1) {
            return arg0.getValue().compareTo(arg1.getValue());
        }
    };

    public static String toString(Map<?, ?> map) {
        if (map.size() == 0) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Map.Entry<?, ?> kv : map.entrySet()) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"");
            sb.append(kv.getKey());
            sb.append("\":\"");
            sb.append(kv.getValue());
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    public static <K, V> String toStringMultiline(Map<K, V> map) {
        if (map.size() == 0) {
            return "{}";
        }
        return MapTools.toStringMultiline(map.entrySet());
    }

    public static <K, V> String toStringMultiline(Set<Map.Entry<K, V>> entrySet) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        for (Map.Entry<K, V> kv : entrySet) {
            sb.append("\t\"");
            sb.append(kv.getKey());
            sb.append("\":\"");
            V val = kv.getValue();
            if (val == null) {
                sb.append("null");
            } else if (val.getClass().isArray() && Object.class.isAssignableFrom(val.getClass().getComponentType())) {
                sb.append(Arrays.toString((Object[])kv.getValue()));
            } else {
                sb.append(kv.getValue());
            }
            sb.append("\"\n");
        }
        sb.append("}");
        return sb.toString();
    }

    public static <K, T> T getIfType(Map<K, ?> map, K key, Class<T> type) {
        Object o = map.get(key);
        return (T)(type.isAssignableFrom(type) ? o : null);
    }

    public static <K extends Comparable<K>> K highestKey(Map<K, ?> map) {
        Comparable ret = null;
        for (Map.Entry<K, ?> kv : map.entrySet()) {
            Comparable k = (Comparable)kv.getKey();
            if (k == null) continue;
            if (ret == null) {
                ret = k;
                continue;
            }
            if (ret.compareTo(k) >= 0) continue;
            ret = k;
        }
        return (K)ret;
    }

    public static <K extends Comparable<K>> K lowsetKey(Map<K, ?> map) {
        Comparable ret = null;
        for (Map.Entry<K, ?> kv : map.entrySet()) {
            Comparable k = (Comparable)kv.getKey();
            if (k == null) continue;
            if (ret == null) {
                ret = k;
                continue;
            }
            if (ret.compareTo(k) <= 0) continue;
            ret = k;
        }
        return (K)ret;
    }

    public static <K extends Comparable<K>, V> List<Map.Entry<K, V>> sortByKeys(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> ret = new ArrayList<Map.Entry<K, V>>();
        for (Map.Entry<K, V> kv : map.entrySet()) {
            ret.add(kv);
        }
        Collections.sort(ret, comparatorByKey);
        return ret;
    }

    public static <I, V> void index(Map<I, ? extends Collection<V>> index, Collection<V> source, SimpleGet store, GetBy1<I, V> get) {
        for (V k : source) {
            I i = get.getBy(k);
            Collection dst = index.get(i);
            if (dst == null) {
                dst = (Collection)store.get();
                index.put(i, dst);
            }
            dst.add(k);
        }
    }

    public static <K, V> void indirectIndex(Map<K, V> index, Collection<K> coll, GetBy1<V, K> getby) {
        for (K k : coll) {
            V v = getby.getBy(k);
            index.put(k, v);
        }
    }

    public static <K, V> void extractedIndex(Map<K, V> index, Collection<V> coll, GetBy1<K, V> getby) {
        for (V v : coll) {
            K k = getby.getBy(v);
            index.put(k, v);
        }
    }

    public static <K, V> void extractedIndexFirstOnly(Map<K, V> index, Collection<V> coll, GetBy1<K, V> getby) {
        for (V v : coll) {
            K k = getby.getBy(v);
            if (index.containsKey(k)) continue;
            index.put(k, v);
        }
    }

    public static <S, K, V> void indirectIndex(Map<K, V> index, Collection<S> coll, GetBy1<K, S> getKeyBy, GetBy1<V, S> getValueBy) {
        for (S s : coll) {
            K k = getKeyBy.getBy(s);
            V v = getValueBy.getBy(s);
            index.put(k, v);
        }
    }

    public static <K, V extends Comparable<V>> List<Map.Entry<K, V>> sortByValues(Map<K, V> map, Comparator<V> cmp) {
        return MapTools.sortByValues(map, cmp, false);
    }

    public static <K, V extends Comparable<V>> List<Map.Entry<K, V>> sortByValues(Map<K, V> map, final Comparator<V> cmp, final boolean rev) {
        ArrayList<Map.Entry<K, V>> ret = new ArrayList<Map.Entry<K, V>>();
        for (Map.Entry<K, V> kv : map.entrySet()) {
            ret.add(kv);
        }
        Collections.sort(ret, new Comparator<V>(){

            @Override
            public int compare(V o1, V o2) {
                return cmp.compare(o1, o2) * (rev ? -1 : 1);
            }
        });
        return ret;
    }

    public static <K extends Comparable<K>, V> List<Map.Entry<K, V>> sortByKeys(Map<K, V> map, final Comparator<K> cmp) {
        ArrayList<Map.Entry<K, V>> ret = new ArrayList<Map.Entry<K, V>>();
        for (Map.Entry<K, V> kv : map.entrySet()) {
            ret.add(kv);
        }
        Collections.sort(ret, new Comparator<Map.Entry<K, ?>>(){

            @Override
            public int compare(Map.Entry<K, ?> o1, Map.Entry<K, ?> o2) {
                return cmp.compare(o1.getKey(), o2.getKey());
            }
        });
        return ret;
    }

    public static <K, V extends Comparable<V>> List<Map.Entry<K, V>> sortByValues(Map<K, V> map, boolean rev) {
        return MapTools.sortByValues(map, comparatorByVal, rev);
    }

    public static <K, V extends Comparable<V>> List<Map.Entry<K, V>> sortByValues(Map<K, V> map) {
        return MapTools.sortByValues(map, false);
    }

    public static <K, V, T extends Map<K, V>> T inlinePut(T a, K k, V v) {
        a.put(k, v);
        return a;
    }

    public static <K, V, T extends Map<K, V>> T inlinePut(T a, Object ... args) {
        for (int i = 0; i < args.length; i += 2) {
            a.put((Object)args[i], (Object)args[i + 1]);
        }
        return a;
    }

    public static <K, V, T extends Map<K, V>> T inlineSmallMap(Object ... args) {
        SmallMap<Object, Object> a = new SmallMap<Object, Object>();
        for (int i = 0; i < args.length; i += 2) {
            a.put(args[i], args[i + 1]);
        }
        return (T)a;
    }

    public static <K, V, T extends Map<K, V>> T inlineHashMap(Object ... args) {
        HashMap<Object, Object> a = new HashMap<Object, Object>();
        for (int i = 0; i < args.length; i += 2) {
            a.put(args[i], args[i + 1]);
        }
        return (T)a;
    }

    public static <K, V> void putAll(Map<? extends K, ? extends V> source, Map<K, V> destination) {
        for (Map.Entry<K, V> kv : source.entrySet()) {
            destination.put(kv.getKey(), kv.getValue());
        }
    }

    public static <K, V> Map<K, V> entriesAsMap(Map<K, V> map, Collection<Map.Entry<K, V>> dst_kv_url) {
        for (Map.Entry<K, V> kv : dst_kv_url) {
            map.put(kv.getKey(), kv.getValue());
        }
        return map;
    }

    public static <R, P> R getOrCreate(Map<P, R> map, P key, GetBy1<R, P> factory) {
        R ret = map.get(key);
        if (null == ret) {
            R cre = factory.getBy(key);
            if (null == cre) {
                return null;
            }
            map.put(key, cre);
            return cre;
        }
        return ret;
    }

    public static <K> Map ensureMapInMap(Map<K, ?> map, K key, SimpleGet factory) {
        Map ret = (Map)map.get(key);
        if (null == ret) {
            ret = (Map)factory.get();
            map.put(key, ret);
        }
        return ret;
    }

    public static <K, V> Map<K, V> ensureSmallMapKey(Map<K, V> map, K key) {
        return MapTools.ensureMapInMap(map, key, SimpleGetFactory.getSmallMapFactory());
    }

    public static <T> Map<String, T> firstValues(Map<String, T[]> map) {
        SmallMap<String, T> ret = new SmallMap<String, T>();
        for (Map.Entry<String, T[]> kv : map.entrySet()) {
            T[] in = kv.getValue();
            if (null == in || 0 == in.length) continue;
            ret.put(kv.getKey(), in[0]);
        }
        return ret;
    }

    public static <K, V> Map<K, V> inlineFill(Map<K, V> map, Object ... key_val) {
        for (int i = 0; i < key_val.length; i += 2) {
            map.put(key_val[i], key_val[i + 1]);
        }
        return map;
    }

    public static <T> Map<T, Integer> population(Collection<T> c) {
        HashMap<T, Integer> ret = new HashMap<T, Integer>();
        for (T t : c) {
            Integer nums = (Integer)ret.get(t);
            nums = null == nums ? Integer.valueOf(1) : Integer.valueOf(nums + 1);
            ret.put(t, nums);
        }
        return ret;
    }

    public static <K, V> V ensureKey(Map<K, V> map, K key, SimpleGet<V> init) {
        V ret = map.get(key);
        if (ret == null) {
            ret = init.get();
            map.put(key, ret);
        }
        return ret;
    }

    public static <K, V> Map<V, K> reverse(Map<K, V> from, Map<V, K> dst) {
        for (Map.Entry<K, V> kv : from.entrySet()) {
            dst.put(kv.getValue(), kv.getKey());
        }
        return dst;
    }

    public static <T> void incrementCount(Map<T, Integer> counts, T item) {
        Integer in = counts.get(item);
        in = null == in ? Integer.valueOf(1) : Integer.valueOf(in + 1);
        counts.put(item, in);
    }

    public static <K, V> void extractListOfMapsTo(Map<V, V> dst, Collection<Map<K, V>> from, K asKey, K asValue) {
        for (Map<K, V> p : from) {
            dst.put(p.get(asKey), p.get(asValue));
        }
    }
}

