/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.collection.map;

import eu.javaexperience.collection.iterator.NotNullIterable;
import eu.javaexperience.collection.map.KeyVal;
import eu.javaexperience.collection.map.MapTools;
import eu.javaexperience.collection.set.ArrayAsSetRO;
import eu.javaexperience.interfaces.simple.publish.SimplePublish3;
import eu.javaexperience.reflect.Mirror;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class SmallMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    Object[] keys;
    Object[] vals;
    int ep = 0;
    int kvs = 0;

    public SmallMap() {
        this.keys = Mirror.emptyObjectArray;
        this.vals = Mirror.emptyObjectArray;
    }

    public SmallMap(Map<K, V> from) {
        int initalLength = from.size();
        this.keys = new Object[initalLength];
        this.vals = new Object[initalLength];
        for (Map.Entry<K, V> kv : from.entrySet()) {
            this.put(kv.getKey(), kv.getValue());
        }
    }

    public SmallMap(int initalLength) {
        this.keys = new Object[initalLength];
        this.vals = new Object[initalLength];
    }

    @Override
    public int size() {
        return this.kvs;
    }

    @Override
    public boolean isEmpty() {
        return this.kvs == 0;
    }

    @Override
    public boolean containsKey(Object paramObject) {
        for (int i = 0; i < this.ep; ++i) {
            if (!paramObject.equals(this.keys[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object paramObject) {
        for (int i = 0; i < this.ep; ++i) {
            if (!paramObject.equals(this.vals[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object paramObject) {
        if (paramObject == null) {
            return null;
        }
        for (int i = 0; i < this.ep; ++i) {
            if (!paramObject.equals(this.keys[i])) continue;
            return (V)this.vals[i];
        }
        return null;
    }

    private void inc() {
        if (this.ep == this.keys.length) {
            int len = this.keys.length * 2;
            if (0 == len) {
                len = 4;
            }
            this.keys = Arrays.copyOf(this.keys, len);
            this.vals = Arrays.copyOf(this.vals, len);
        }
    }

    @Override
    public V put(K paramK, V paramV) {
        int i;
        for (i = 0; i < this.ep; ++i) {
            if (!paramK.equals(this.keys[i])) continue;
            Object ret = this.vals[i];
            this.vals[i] = paramV;
            return (V)ret;
        }
        if (this.ep == this.kvs) {
            this.inc();
            this.keys[this.kvs++] = paramK;
            this.vals[this.ep++] = paramV;
        } else {
            for (i = 0; i < this.ep; ++i) {
                if (this.keys[i] != null) continue;
                this.keys[i] = paramK;
                this.vals[i] = paramV;
                ++this.kvs;
                this.inc();
                break;
            }
        }
        return null;
    }

    @Override
    public V remove(Object paramObject) {
        for (int i = 0; i < this.ep; ++i) {
            if (!paramObject.equals(this.keys[i])) continue;
            Object ret = this.vals[i];
            this.keys[i] = null;
            this.vals[i] = null;
            --this.kvs;
            if (i == this.ep - 1) {
                --this.ep;
            }
            return (V)ret;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> paramMap) {
        for (Map.Entry<K, V> kv : paramMap.entrySet()) {
            this.put(kv.getKey(), kv.getValue());
        }
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.ep; ++i) {
            this.vals[i] = null;
            this.keys[i] = null;
        }
        this.ep = 0;
        this.kvs = 0;
    }

    @Override
    public Set<K> keySet() {
        Object[] ret = new Object[this.kvs];
        int cep = 0;
        for (int i = 0; i < this.ep; ++i) {
            if (this.keys[i] == null) continue;
            ret[cep++] = this.keys[i];
        }
        if (cep == ret.length) {
            return new ArrayAsSetRO<Object>(ret);
        }
        return new ArrayAsSetRO<Object>(Arrays.copyOf(ret, cep));
    }

    @Override
    public Collection<V> values() {
        Object[] ret = new Object[this.kvs];
        int aep = 0;
        for (int i = 0; i < this.ep; ++i) {
            if (this.vals[i] == null) continue;
            ret[aep++] = this.vals[i];
        }
        if (aep == ret.length) {
            return new ArrayAsSetRO<Object>(ret);
        }
        return new ArrayAsSetRO<Object>(Arrays.copyOf(ret, aep));
    }

    public K getKeyByValue(V val) {
        for (int i = 0; i < this.ep; ++i) {
            if (!val.equals(this.vals[i])) continue;
            return (K)this.keys[i];
        }
        return null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        KeyVal[] ret = new KeyVal[this.kvs];
        int cep = 0;
        for (int i = 0; i < this.ep; ++i) {
            if (this.keys[i] == null) continue;
            ret[cep++] = new KeyVal<Object, Object>(this.keys[i], this.vals[i]);
        }
        return new ArrayAsSetRO<Map.Entry<K, V>>(ret);
    }

    public SmallMap<K, V> clone() {
        SmallMap<K, V> ret = new SmallMap<K, V>();
        ret.keys = Arrays.copyOf(this.keys, this.keys.length);
        ret.vals = Arrays.copyOf(this.vals, this.vals.length);
        ret.kvs = this.kvs;
        ret.ep = this.ep;
        return ret;
    }

    public Iterable<K> getKeyIterator() {
        return NotNullIterable.whitoutNulls(this.keys);
    }

    public <T> void each(SimplePublish3<K, V, T> pub, T param) {
        for (int i = 0; i < this.ep; ++i) {
            pub.publish(this.keys[i], this.vals[i], param);
        }
    }

    public String toString() {
        return MapTools.toStringMultiline(this);
    }
}

