/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.collection.set;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class ArrayAsSet<T>
implements Set<T> {
    Object[] arr;
    int ep = 0;
    int vals = 0;

    public ArrayAsSet() {
        this.arr = new Object[8];
    }

    ArrayAsSet(T[] arr, int ep, int vals) {
        this.arr = arr;
        this.ep = ep;
        this.vals = vals;
    }

    @Override
    public int size() {
        return this.vals;
    }

    @Override
    public boolean isEmpty() {
        return this.vals == 0;
    }

    @Override
    public boolean contains(Object paramObject) {
        for (int i = 0; i < this.ep; ++i) {
            if (!paramObject.equals(this.arr[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int rets = 0;
            int cep = 0;

            @Override
            public boolean hasNext() {
                return this.rets < ArrayAsSet.this.vals;
            }

            @Override
            public T next() {
                for (int i = this.cep; i < ArrayAsSet.this.ep; ++i) {
                    if (ArrayAsSet.this.arr[i] == null) continue;
                    this.cep = i + 1;
                    ++this.rets;
                    return ArrayAsSet.this.arr[i];
                }
                return null;
            }

            @Override
            public void remove() {
                ArrayAsSet.this.remove(ArrayAsSet.this.arr[this.cep - 1]);
            }
        };
    }

    @Override
    public Object[] toArray() {
        Object[] ret = new Object[this.vals];
        int ep = 0;
        for (int i = 0; i < ep; ++i) {
            if (this.arr[i] == null) continue;
            ret[ep++] = this.arr[i];
        }
        return ret;
    }

    @Override
    public <T> T[] toArray(T[] paramArrayOfT) {
        T[] ret = Arrays.copyOf(paramArrayOfT, this.vals);
        int ep = 0;
        for (int i = 0; i < ep; ++i) {
            if (this.arr[i] == null) continue;
            ret[ep++] = this.arr[i];
        }
        return ret;
    }

    protected void inc() {
        if (this.ep == this.arr.length) {
            this.arr = Arrays.copyOf(this.arr, this.arr.length * 2);
        }
    }

    @Override
    public boolean add(T paramE) {
        int i;
        for (i = 0; i < this.ep; ++i) {
            if (!paramE.equals(this.arr[i])) continue;
            return false;
        }
        if (this.ep == this.vals) {
            this.arr[this.ep++] = paramE;
            ++this.vals;
            this.inc();
        } else {
            for (i = 0; i < this.ep; ++i) {
                if (this.arr[i] != null) continue;
                this.arr[i] = paramE;
                ++this.vals;
                break;
            }
        }
        return true;
    }

    @Override
    public boolean remove(Object paramObject) {
        for (int i = 0; i < this.ep; ++i) {
            if (!paramObject.equals(this.arr[i])) continue;
            this.arr[i] = null;
            --this.vals;
            if (i == this.ep - 1) {
                --this.ep;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> paramCollection) {
        block0: for (Object o : paramCollection) {
            for (int i = 0; i < this.ep; ++i) {
                if (o.equals(this.arr[i])) continue block0;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> paramCollection) {
        boolean ret = true;
        for (T o : paramCollection) {
            ret &= this.add(o);
        }
        return ret;
    }

    @Override
    public boolean retainAll(Collection<?> paramCollection) {
        boolean ret = true;
        block0: for (int i = 0; i < this.ep; ++i) {
            if (this.arr[i] != null) {
                for (Object o : paramCollection) {
                    if (!this.arr[i].equals(o)) continue;
                    continue block0;
                }
            }
            this.remove(this.arr[i]);
            ret = false;
        }
        return ret;
    }

    @Override
    public boolean removeAll(Collection<?> paramCollection) {
        boolean ret = true;
        for (Object o : paramCollection) {
            ret &= this.remove(o);
        }
        return ret;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.ep; ++i) {
            this.arr[i] = null;
        }
        this.ep = 0;
        this.vals = 0;
    }
}

