/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.collection.tree;

import eu.javaexperience.arrays.ArrayTools;
import eu.javaexperience.collection.tree.TreeNode;
import eu.javaexperience.exceptions.OperationSuccessfullyEnded;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish3;
import eu.javaexperience.reflect.Mirror;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class TreeMerger<N extends TreeNode<N>>
implements Iterable<N>,
Serializable {
    protected ArrayList<N> roots = new ArrayList();
    protected Map<Object, N> idToNode = new HashMap<Object, N>();
    protected static String COLLAPSE_CSS = "";

    public void mergeChain(N node) {
        this.mergeInternal(null, node);
    }

    protected void mergeInternal(N prevIn, N crnt) {
        Object id = this.getIdOf(crnt);
        TreeNode in = (TreeNode)this.idToNode.get(id);
        if (null == in) {
            ((TreeNode)crnt).setParent(null);
            if (null != prevIn) {
                ((TreeNode)prevIn).addChild(crnt);
            } else {
                this.roots.add(crnt);
            }
            this.indexFromDescendants(crnt);
            return;
        }
        for (TreeNode c : ((TreeNode)crnt).childs.toArray(TreeNode.emptyTreeNodeArray)) {
            this.mergeInternal(in, c);
        }
    }

    protected void indexFromDescendants(N crnt) {
        this.idToNode.put(this.getIdOf(crnt), crnt);
        for (TreeNode tn : crnt) {
            this.indexFromDescendants(tn);
        }
    }

    public Iterable<N> iterateAll() {
        return this.idToNode.values();
    }

    public abstract Object getIdOf(N var1);

    public abstract String getNameOf(N var1);

    public static <N extends TreeNode<N>> void renderNodeHtml(Appendable app, TreeMerger<N> logic, N node) throws IOException {
        app.append("<ul>\n");
        app.append("\t<li><input type=\"checkbox\" id=\"" + node.hashCode() + "\"/><label " + (node.childs.size() == 0 ? "class=\"leaf\"" : "") + " for=\"" + node.hashCode() + "\" data-cid=\"" + logic.getIdOf(node) + "\">");
        app.append(logic.getNameOf(node));
        app.append("[" + node + "]");
        app.append("</label>\n");
        for (TreeNode c : node) {
            TreeMerger.renderNodeHtml(app, logic, c);
        }
        app.append("</ul>");
    }

    public void toHtmlTree(Appendable app) throws IOException {
        app.append(TreeMerger.getCollapseCSS());
        for (TreeNode n : this.roots) {
            TreeMerger.renderNodeHtml(app, this, n);
        }
    }

    public static <P, N extends TreeNode<N>> void render(P param, SimplePublish3<P, N, TreeMerger<N>> renderer, TreeMerger<N> logic, N node) {
        if (null != node) {
            renderer.publish(param, node, logic);
        }
        ArrayList<N> it = null == node ? logic.roots : node;
        Iterator iterator = it.iterator();
        while (iterator.hasNext()) {
            TreeNode n = (TreeNode)iterator.next();
            TreeMerger.render(param, renderer, logic, n);
        }
    }

    public <P> void render(P param, SimplePublish3<P, N, TreeMerger<N>> renderer) {
        for (TreeNode n : this.roots) {
            TreeMerger.render(param, renderer, this, n);
        }
    }

    public String toHtmlTree() throws IOException {
        StringBuilder sb = new StringBuilder();
        this.toHtmlTree(sb);
        return sb.toString();
    }

    public static String getCollapseCSS() {
        return COLLAPSE_CSS;
    }

    @Override
    public Iterator<N> iterator() {
        return this.roots.iterator();
    }

    protected N findById(N node, Object id) {
        if (this.getIdOf(node).equals(id)) {
            return node;
        }
        for (TreeNode n : node) {
            TreeNode ret = this.findById(n, id);
            if (null == ret) continue;
            return (N)ret;
        }
        return null;
    }

    public N findById(Object s) {
        for (TreeNode root : this.roots) {
            TreeNode ret = this.findById(root, s);
            if (null == ret) continue;
            return (N)ret;
        }
        return null;
    }

    public void ensureKnown(N node) {
        this.indexFromDescendants(node);
        if (null == ((TreeNode)node).parent) {
            this.roots.add(node);
        }
    }

    public String[] getPath(N node) {
        String[] path = (String[])((TreeNode)node).getEtc("str_path");
        if (null == path) {
            ArrayList<String> re = new ArrayList<String>();
            N n = node;
            do {
                re.add(this.getNameOf(n));
            } while (null != (n = ((TreeNode)n).parent));
            path = ArrayTools.modifyReverse(re.toArray(Mirror.emptyStringArray));
            ((TreeNode)node).putEtc("str_path", path);
        }
        return path;
    }

    public boolean tryMatchBackward(N node, String ... path) {
        String[] pattern = path;
        String[] search = this.getPath(node);
        if (pattern.length > search.length) {
            return false;
        }
        for (int i = 0; i < pattern.length; ++i) {
            if (pattern[pattern.length - 1 - i].equalsIgnoreCase(search[search.length - 1 - i])) continue;
            return false;
        }
        return true;
    }

    public int findAllByName(Collection<N> nodes, String ... path) {
        int ret = 0;
        for (Map.Entry<Object, N> kv : this.idToNode.entrySet()) {
            if (!this.tryMatchBackward((TreeNode)kv.getValue(), path)) continue;
            ++ret;
            nodes.add(kv.getValue());
        }
        return ret;
    }

    public N findSingleUnique(String ... name) {
        ArrayList re = new ArrayList();
        this.findAllByName(re, name);
        if (0 == re.size()) {
            return null;
        }
        if (1 == re.size()) {
            return (N)((TreeNode)re.get(0));
        }
        throw new RuntimeException("Node name not unique: " + Arrays.toString(name));
    }

    public void reindex() {
        this.idToNode.clear();
        SimplePublish1 add = new SimplePublish1<N>(){

            @Override
            public void publish(N a) {
                TreeMerger.this.idToNode.put(TreeMerger.this.getIdOf(a), a);
            }
        };
        for (TreeNode r : this.roots) {
            r.iterateThisAndChilds(add);
        }
    }

    public void unlink(N node) {
        ((TreeNode)node).unlink();
        if (null == ((TreeNode)node).parent) {
            this.roots.remove(node);
        }
        this.reindex();
    }

    public void dropCategoryAndAdoptChilds(N elem) {
        TreeNode parent = ((TreeNode)elem).parent;
        ((TreeNode)elem).unlink();
        if (null != parent) {
            for (TreeNode e : elem) {
                e.parent = elem;
                parent.addChild((TreeNode)e);
            }
        } else {
            this.roots.remove(elem);
            for (TreeNode e : elem) {
                e.parent = null;
                this.roots.add(e);
            }
        }
        this.reindex();
    }

    public int getAbsOrder(N node) {
        int[] ordinal_registry = new int[]{0, -1};
        SimplePublish1 it = new SimplePublish1<N>((TreeNode)node, ordinal_registry){
            final /* synthetic */ TreeNode val$node;
            final /* synthetic */ int[] val$ordinal_registry;
            {
                this.val$node = treeNode;
                this.val$ordinal_registry = nArray;
            }

            @Override
            public void publish(N a) {
                if (a == this.val$node) {
                    this.val$ordinal_registry[1] = this.val$ordinal_registry[0];
                    throw OperationSuccessfullyEnded.instance;
                }
                this.val$ordinal_registry[0] = this.val$ordinal_registry[0] + 1;
            }
        };
        try {
            for (TreeNode n : this.roots) {
                n.iterateThisAndChilds(it);
            }
        }
        catch (OperationSuccessfullyEnded operationSuccessfullyEnded) {
            // empty catch block
        }
        return ordinal_registry[1];
    }

    public void orderTree(Comparator<N> cmp) {
        Collections.sort(this.roots, cmp);
        for (TreeNode c : this.iterateAll()) {
            c.reorderChilds(cmp);
        }
    }

    public boolean tryAddChild(Object parentId, N childNode) {
        TreeNode p = (TreeNode)this.idToNode.get(parentId);
        if (null == p) {
            return false;
        }
        p.addChild(childNode);
        this.indexFromDescendants(childNode);
        return true;
    }

    public void fillNodesInOrder(final Collection<? super N> dst) {
        for (TreeNode n : this.roots) {
            n.iterateThisAndChilds(new SimplePublish1<N>(){

                @Override
                public void publish(N a) {
                    dst.add(a);
                }
            });
        }
    }

    public void findNodesByName(Collection<N> nodes, GetBy1<Boolean, String> contains) {
        for (Map.Entry<Object, N> kv : this.idToNode.entrySet()) {
            if (!contains.getBy(this.getNameOf((TreeNode)kv.getValue())).booleanValue()) continue;
            nodes.add(kv.getValue());
        }
    }

    public void walkTree(SimplePublish1<? extends TreeNode<N>> publish) {
        for (TreeNode e : this.roots) {
            e.walkTree(publish);
        }
    }

    static {
        try {
            COLLAPSE_CSS = new String(Mirror.getPackageResource(TreeMerger.class, "collapse.css"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

