/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.collection.tree;

import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.collection.tree.TreeMerger;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.text.StringTools;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TreeNode<N extends TreeNode<N>>
implements Iterable<N>,
Serializable {
    private static final long serialVersionUID = -1353360183790746251L;
    public static TreeNode[] emptyTreeNodeArray = new TreeNode[0];
    protected Map<Object, Object> etc;
    protected N parent;
    protected ArrayList<N> childs = new ArrayList();

    public Object getEtc(Object key) {
        if (null == this.etc) {
            return null;
        }
        return this.etc.get(key);
    }

    public Object putEtc(Object key, Object val) {
        if (null == this.etc) {
            this.etc = new SmallMap<Object, Object>();
        }
        return this.etc.put(key, val);
    }

    protected void clearEtc() {
        if (null != this.etc) {
            this.etc.clear();
        }
    }

    public void reorderChilds(Comparator<N> cmp) {
        Collections.sort(this.childs, cmp);
    }

    public void addChild(N child) {
        if (null != ((TreeNode)child).parent) {
            throw new RuntimeException("TreeNode already have parent.");
        }
        ((TreeNode)child).parent = this;
        this.childs.add(child);
    }

    public N getParent() {
        return this.parent;
    }

    public N setParent(N parent) {
        N ret = this.parent;
        this.parent = parent;
        return ret;
    }

    public final void unlink() {
        if (null != this.parent) {
            ((TreeNode)this.parent).childs.remove(this);
        }
        this.parent = null;
    }

    public String getPath(TreeMerger<N> merger, String separator) {
        return this.appendYourselfBefore(merger, separator, null);
    }

    protected String appendYourselfBefore(TreeMerger<N> merger, String separator, String currentString) {
        String myName = merger.getNameOf(this);
        currentString = StringTools.isNullOrTrimEmpty(currentString) ? myName : myName + separator + currentString;
        if (null != this.parent) {
            return this.parent.appendYourselfBefore(merger, separator, currentString);
        }
        return currentString;
    }

    @Override
    public Iterator<N> iterator() {
        return this.childs.iterator();
    }

    public void iterateThisAndChilds(SimplePublish1<N> pub) {
        pub.publish(this);
        for (TreeNode ch : this) {
            ch.iterateThisAndChilds(pub);
        }
    }

    public int getLevel() {
        if (null == this.parent) {
            return 0;
        }
        return ((TreeNode)this.parent).getLevel() + 1;
    }

    public void iterateAllChild(SimplePublish1<N> pub) {
        for (TreeNode n : this) {
            n.iterateThisAndChilds(pub);
        }
    }

    public List<N> getChilds() {
        return this.childs;
    }

    public void walkTree(SimplePublish1<? extends TreeNode<N>> publish) {
        publish.publish(this);
        for (TreeNode c : this.childs) {
            c.walkTree(publish);
        }
    }
}

