/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.config;

import eu.javaexperience.Global;
import eu.javaexperience.arrays.ArrayTools;
import eu.javaexperience.collection.enumerations.EnumTools;
import eu.javaexperience.io.file.FileTools;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.parse.ParsePrimitive;
import eu.javaexperience.reflect.CastTo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Properties;

public class ConfigTools {
    public static final Logger LOG = JavaExperienceLoggingFacility.getLogger(new Loggable("ConfigTools"));

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties loadFirstConfig(String ... files) {
        if (null == files || 0 == files.length) {
            LoggingTools.tryLogSimple(LOG, (LoggingDetailLevel)LogLevel.DEBUG, "No config files given, spoofing default files for config loader.");
            return ConfigTools.loadFirstConfig("settings.properties", "setting.properties", "config.properties", "srv/settings.properties", "srv/setting.properties", "srv/config.properties", "bin/settings.properties", "bin/setting.properties", "bin/config.properties");
        }
        if (LOG.mayLog(LogLevel.DEBUG)) {
            try {
                LoggingTools.tryLogFormat(LOG, (LoggingDetailLevel)LogLevel.DEBUG, "Config load stage, current working directory is %s", (Object)new File(".").getCanonicalFile());
            }
            catch (Exception e) {
                LoggingTools.tryLogSimple(LOG, LogLevel.DEBUG, "Unable to log Current Working Directory", e);
            }
        }
        String[] stringArray = files;
        int n = stringArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                LoggingTools.tryLogSimple(LOG, (LoggingDetailLevel)LogLevel.DEBUG, "No config files are loaded in this stage.");
                return null;
            }
            String file = stringArray[n2];
            File f = new File(file);
            if (!f.exists()) {
                LoggingTools.tryLogFormat(LOG, (LoggingDetailLevel)LogLevel.DEBUG, "Result of config file loading `%s`: file doesn't exists (canonical file is: %s)", (Object)file, (Object)FileTools.tryGetCanonicalFile(f));
            } else {
                try (FileInputStream is = new FileInputStream(f);){
                    Properties p = new Properties();
                    p.load(new BufferedReader(new InputStreamReader(is)));
                    LoggingTools.tryLogFormat(LOG, (LoggingDetailLevel)LogLevel.INFO, "Config file `%s` successfully loaded  (canonical file is: %s).", (Object)file, (Object)FileTools.tryGetCanonicalFile(f));
                    Properties properties = p;
                    return properties;
                }
                catch (Exception e) {
                    LoggingTools.tryLogFormat(LOG, (LoggingDetailLevel)LogLevel.DEBUG, "Loading config file `%s` (canonical file is: %s) refused by Exception: ", (Object)file, (Object)FileTools.tryGetCanonicalFile(f));
                }
            }
            ++n2;
        }
    }

    public static boolean loadConfig(String ... files) {
        Properties p = ConfigTools.loadFirstConfig(files);
        if (null != p) {
            for (Map.Entry<Object, Object> kv : p.entrySet()) {
                Global.putProperty(kv.getKey(), kv.getValue());
            }
            return true;
        }
        return false;
    }

    protected static void notNullOrThrow(Object subject, String key) {
        if (null == subject) {
            throw new RuntimeException("No configuration value specified under key: " + key);
        }
    }

    public static <E extends Enum<E>> E getGlobalValuableEnum(Class<? extends E> cls, String key) {
        Object prop = Global.getProperty(key);
        ConfigTools.notNullOrThrow(prop, key);
        Enum ret = (Enum)EnumTools.recogniseSymbol(cls, prop);
        if (null == ret) {
            throw new RuntimeException("Can't recognise enum: `" + prop + "` under key: `" + key + "`. Possible values: " + ArrayTools.toString(cls.getEnumConstants()));
        }
        return (E)ret;
    }

    public static String getGlobalValuableString(String key) {
        Object prop = Global.getProperty(key);
        ConfigTools.notNullOrThrow(prop, key);
        return String.valueOf(prop.toString());
    }

    public static int getGlobalValuableInt(String key) {
        Object prop = Global.getProperty(key);
        ConfigTools.notNullOrThrow(prop, key);
        Integer ret = ParsePrimitive.tryParseInt(prop.toString());
        if (null == ret) {
            throw new RuntimeException("Can't recognise integer number: `" + prop + "` under key: `" + key + "`.");
        }
        return ret;
    }

    public static double getGlobalValuableDouble(String key) {
        Object prop = Global.getProperty(key);
        ConfigTools.notNullOrThrow(prop, key);
        Double ret = ParsePrimitive.tryParseDouble(prop.toString());
        if (null == ret) {
            throw new RuntimeException("Can't recognise double float number: `" + prop + "` under key: `" + key + "`.");
        }
        return ret;
    }

    public static boolean getGlobalValuableBoolean(String key) {
        Object prop = Global.getProperty(key);
        ConfigTools.notNullOrThrow(prop, key);
        Boolean ret = (Boolean)CastTo.Boolean.cast(prop);
        if (null == ret) {
            throw new RuntimeException("Can't recognise boolean: `" + prop + "` under key: `" + key + "`.");
        }
        return ret;
    }
}

