/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.database;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.database.ConnectionBuilder;
import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.reflect.Mirror;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class ConnectionCreator
implements SimpleGet<Connection> {
    public static ConnectionCreator fromConnectionBuilder(final ConnectionBuilder builder, final String host, final int port, final String user, final String password, final String db) {
        AssertArgument.assertNotNull((Object)builder, "type");
        return new ConnectionCreator(){

            @Override
            public Connection get() {
                try {
                    if (port < 0) {
                        if (host == null) {
                            return builder.openConnection(user, password, db);
                        }
                        return builder.openConnection(host, user, password, db);
                    }
                    return builder.openConnection(host, port, user, password, db);
                }
                catch (SQLException e) {
                    Mirror.propagateAnyway(e);
                    return null;
                }
            }
        };
    }
}

