/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.database.accessModel;

import eu.javaexperience.database.accessModel.AccessRequest;
import eu.javaexperience.database.accessModel.OptionEntry;
import eu.javaexperience.database.accessModel.OptionGroup;
import eu.javaexperience.database.accessModel.WellKnownAccessQueryOptions;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class DataAccessModel<M, ENV> {
    protected final String name;
    protected Map<String, OptionGroup> queryOptions = new HashMap<String, OptionGroup>();

    public String getName() {
        return this.name;
    }

    public DataAccessModel(String modelName) {
        this.name = modelName;
    }

    public DataAccessModel(String modelName, OptionGroup ... options) {
        this.name = modelName;
        for (OptionGroup g : options) {
            this.queryOptions.put(g.systemName, g);
        }
    }

    protected abstract AccessRequest<M, ENV> createAccessRequest();

    public AccessRequest<M, ENV> createRequest() {
        AccessRequest<M, ENV> req = this.createAccessRequest();
        req.model = this;
        return req;
    }

    public void addOption(OptionGroup optionGroup) {
        this.queryOptions.put(optionGroup.systemName, optionGroup);
    }

    public int fillAvailableOptionsOf(String entity, Collection<OptionEntry> orderings) {
        OptionGroup og = this.queryOptions.get(entity);
        if (null == og) {
            return -1;
        }
        int n = 0;
        for (OptionEntry f : og.options) {
            orderings.add(f);
            ++n;
        }
        return n;
    }

    public int fillAvailableOptionsOf(WellKnownAccessQueryOptions entitiy, Collection<OptionEntry> options) {
        return this.fillAvailableOptionsOf(entitiy.name(), options);
    }

    public OptionGroup getOptionByName(String name) {
        return this.queryOptions.get(name);
    }

    public Iterable<String> getOptionNames() {
        return this.queryOptions.keySet();
    }
}

