/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.database.collection;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.collection.map.KeyVal;
import eu.javaexperience.collection.set.ArrayListSeemsSet;
import eu.javaexperience.reflect.Mirror;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class JdbcMap<K, V>
implements Map<K, V> {
    protected JdbcMapImplProvider<K, V> prov;

    public JdbcMap(JdbcMapImplProvider<K, V> prov) {
        this.prov = prov;
        AssertArgument.assertNotNull(this.prov, "jdbc map implemntation provider");
    }

    @Override
    public int size() {
        Connection conn = null;
        try {
            conn = this.prov.getConnection();
            int n = this.prov.getMappingCount(conn);
            return n;
        }
        finally {
            if (null != conn) {
                this.prov.releaseConnection(conn);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean containsKey(Object key) {
        Connection conn = null;
        try {
            boolean bl;
            Throwable throwable;
            ResultSet rs;
            block20: {
                block21: {
                    conn = this.prov.getConnection();
                    rs = this.prov.selectWhereKey(conn, key);
                    throwable = null;
                    bl = rs.next();
                    if (rs == null) break block20;
                    if (throwable == null) break block21;
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block20;
                }
                rs.close();
            }
            return bl;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (rs != null) {
                            if (throwable != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                rs.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (SQLException e) {
                    Mirror.throwSoftOrHardButAnyway(e);
                    boolean bl2 = false;
                    if (null != conn) {
                        this.prov.releaseConnection(conn);
                    }
                    return bl2;
                }
            }
        }
        finally {
            if (null != conn) {
                this.prov.releaseConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean containsValue(Object value) {
        Connection conn = null;
        try {
            boolean bl;
            Throwable throwable;
            ResultSet rs;
            block20: {
                block21: {
                    conn = this.prov.getConnection();
                    rs = this.prov.selectWhereValue(conn, value);
                    throwable = null;
                    bl = rs.next();
                    if (rs == null) break block20;
                    if (throwable == null) break block21;
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block20;
                }
                rs.close();
            }
            return bl;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (rs != null) {
                            if (throwable != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                rs.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (SQLException e) {
                    Mirror.throwSoftOrHardButAnyway(e);
                    boolean bl2 = false;
                    if (null != conn) {
                        this.prov.releaseConnection(conn);
                    }
                    return bl2;
                }
            }
        }
        finally {
            if (null != conn) {
                this.prov.releaseConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public V get(Object key) {
        Connection conn = null;
        try {
            V v;
            Throwable throwable;
            ResultSet rs;
            block26: {
                block27: {
                    block23: {
                        V v2;
                        block24: {
                            block25: {
                                conn = this.prov.getConnection();
                                rs = this.prov.selectWhereKey(conn, key);
                                throwable = null;
                                if (!rs.next()) break block23;
                                v2 = this.prov.extractValue(rs);
                                if (rs == null) break block24;
                                if (throwable == null) break block25;
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block24;
                            }
                            rs.close();
                        }
                        return v2;
                    }
                    v = null;
                    if (rs == null) break block26;
                    if (throwable == null) break block27;
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block26;
                }
                rs.close();
            }
            return v;
            {
                catch (Throwable throwable4) {
                    try {
                        try {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (rs != null) {
                                if (throwable != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    rs.close();
                                }
                            }
                            throw throwable5;
                        }
                    }
                    catch (SQLException e) {
                        Mirror.throwSoftOrHardButAnyway(e);
                        throwable = null;
                        return (V)throwable;
                    }
                }
            }
        }
        finally {
            if (null != conn) {
                this.prov.releaseConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        Connection conn = null;
        try {
            conn = this.prov.getConnection();
            V v = this.prov.insertOrUpdate(conn, key, value);
            return v;
        }
        finally {
            if (null != conn) {
                this.prov.releaseConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        Connection conn = null;
        try {
            conn = this.prov.getConnection();
            V v = this.prov.removeByKey(conn, key);
            return v;
        }
        finally {
            if (null != conn) {
                this.prov.releaseConnection(conn);
            }
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> kv : m.entrySet()) {
            this.put(kv.getKey(), kv.getValue());
        }
    }

    @Override
    public void clear() {
        Connection conn = null;
        try {
            conn = this.prov.getConnection();
            this.prov.emptyOutMapping(conn);
        }
        finally {
            if (null != conn) {
                this.prov.releaseConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        ArrayListSeemsSet<K> ret = new ArrayListSeemsSet<K>();
        Connection conn = null;
        try {
            conn = this.prov.getConnection();
            try (ResultSet rs = this.prov.selectAll(conn);){
                while (rs.next()) {
                    ret.add(this.prov.extractKey(rs));
                }
            }
            catch (SQLException e) {
                Mirror.throwSoftOrHardButAnyway(e);
            }
        }
        finally {
            if (null != conn) {
                this.prov.releaseConnection(conn);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> values() {
        ArrayList<V> ret = new ArrayList<V>();
        Connection conn = null;
        try {
            conn = this.prov.getConnection();
            try (ResultSet rs = this.prov.selectAll(conn);){
                while (rs.next()) {
                    ret.add(this.prov.extractValue(rs));
                }
            }
            catch (SQLException e) {
                Mirror.throwSoftOrHardButAnyway(e);
            }
        }
        finally {
            if (null != conn) {
                this.prov.releaseConnection(conn);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        ArrayListSeemsSet<Map.Entry<K, V>> ret = new ArrayListSeemsSet<Map.Entry<K, V>>();
        Connection conn = null;
        try {
            conn = this.prov.getConnection();
            try (ResultSet rs = this.prov.selectAll(conn);){
                while (rs.next()) {
                    ret.add(new KeyVal<K, V>(this.prov.extractKey(rs), this.prov.extractValue(rs)));
                }
            }
            catch (SQLException e) {
                Mirror.throwSoftOrHardButAnyway(e);
            }
        }
        finally {
            if (null != conn) {
                this.prov.releaseConnection(conn);
            }
        }
        return ret;
    }

    public static interface JdbcMapImplProvider<K, V> {
        public Connection getConnection();

        public void releaseConnection(Connection var1);

        public ResultSet selectWhereKey(Connection var1, K var2);

        public ResultSet selectWhereValue(Connection var1, V var2);

        public ResultSet selectAll(Connection var1);

        public K extractKey(ResultSet var1);

        public V extractValue(ResultSet var1);

        public V insertOrUpdate(Connection var1, K var2, V var3);

        public V removeByKey(Connection var1, Object var2);

        public int getMappingCount(Connection var1);

        public void emptyOutMapping(Connection var1);
    }
}

