/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.database.impl;

import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.database.jdbc.Id;
import eu.javaexperience.database.pojodb.Model;
import eu.javaexperience.reflect.Mirror;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SqlMappingData {
    protected static Map<Class, SqlMappingData> MAPPING = new ConcurrentHashMap<Class, SqlMappingData>();
    protected Class cls;
    protected Field[] fields;
    protected Map<String, FieldData> fieldNames = new SmallMap<String, FieldData>();
    protected FieldData id;

    protected static Field[] selectFields(Class cls) {
        return Mirror.getClassData(cls).selectFields(new Mirror.FieldSelector(true, Mirror.Visibility.All, Mirror.BelongTo.Instance, Mirror.Select.All, Mirror.Select.IsNot, Mirror.Select.All));
    }

    public static SqlMappingData getOrCreateMapping(Model m) {
        SqlMappingData map = MAPPING.get(m.getClass());
        if (null == map) {
            map = new SqlMappingData();
            map.cls = m.getClass();
            for (Field f : map.fields = SqlMappingData.selectFields(map.cls)) {
                FieldData fd = new FieldData(f);
                map.fieldNames.put(f.getName(), fd);
                if (null == f.getAnnotation(Id.class)) continue;
                map.id = fd;
            }
            MAPPING.put(map.cls, map);
        }
        return map;
    }

    public static class FieldData {
        protected Field field;
        protected boolean isId;

        public FieldData(Field f) {
            this.field = f;
            this.isId = null != f.getAnnotation(Id.class);
        }
    }
}

