/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.database.pojodb;

import eu.javaexperience.database.JDBC;
import eu.javaexperience.database.pojodb.Model;
import eu.javaexperience.database.pojodb.dialect.SqlDialect;
import eu.javaexperience.query.AtomicCondition;
import eu.javaexperience.query.LogicalGroup;
import eu.javaexperience.query.LogicalRelation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;

public class SqlTools {
    public static void buildQuery(StringBuilder sb, LogicalGroup lg, SqlDialect dialect) {
        String quote = dialect.getFieldQuoteString();
        String strQuote = dialect.getStringQuote();
        block1 : switch (lg.getLogicalRelation()) {
            case and: 
            case or: {
                boolean nfirst = false;
                for (LogicalGroup g : lg.getLogicalGroups()) {
                    if (nfirst) {
                        sb.append(lg.getLogicalRelation() == LogicalRelation.and ? " AND " : " OR ");
                    }
                    sb.append("(");
                    SqlTools.buildQuery(sb, g, dialect);
                    sb.append(")");
                    nfirst = true;
                }
                break;
            }
            case unit: {
                AtomicCondition c = lg.getAtomicCondition();
                sb.append(quote);
                sb.append(c.getFieldName());
                sb.append(quote);
                switch (c.getOperator()) {
                    case contains: {
                        if (c.isNegated()) {
                            sb.append(" NOT");
                        }
                        sb.append(" LIKE ");
                        sb.append(strQuote);
                        sb.append("%");
                        String add = (String)c.getValue();
                        if (null == add) {
                            add = "null";
                        }
                        sb.append(dialect.escapeString(add));
                        sb.append("%");
                        sb.append(strQuote);
                        break block1;
                    }
                    case eq: {
                        if (c.getValue() == null) {
                            if (c.isNegated()) {
                                sb.append(" IS NOT NULL");
                                break block1;
                            }
                            sb.append(" IS NULL");
                            break block1;
                        }
                        sb.append(" ");
                        if (c.isNegated()) {
                            sb.append("!");
                        }
                        sb.append("= ");
                        sb.append(dialect.toQueryString(c.getValue()));
                        break block1;
                    }
                    case match: {
                        if (c.isNegated()) {
                            sb.append(" NOT");
                        }
                        sb.append(" REGEX ");
                        sb.append(dialect.toQueryString(c.getValue()));
                        break block1;
                    }
                    case gt: {
                        if (c.isNegated()) {
                            sb.append(" < ");
                        } else {
                            sb.append(" >= ");
                        }
                        sb.append(dialect.toQueryString(c.getValue()));
                        break block1;
                    }
                    case gte: {
                        if (c.isNegated()) {
                            sb.append(" <= ");
                        } else {
                            sb.append(" > ");
                        }
                        sb.append(dialect.toQueryString(c.getValue()));
                        break block1;
                    }
                    case lt: {
                        if (c.isNegated()) {
                            sb.append(" > ");
                        } else {
                            sb.append(" <= ");
                        }
                        sb.append(dialect.toQueryString(c.getValue()));
                        break block1;
                    }
                    case lte: {
                        if (c.isNegated()) {
                            sb.append(" >= ");
                        } else {
                            sb.append(" < ");
                        }
                        sb.append(dialect.toQueryString(c.getValue()));
                        break block1;
                    }
                    case in: {
                        try {
                            Object val = c.getValue();
                            ArrayList<Object> it = null;
                            int length = -1;
                            if (val instanceof Collection) {
                                it = (ArrayList<Object>)val;
                                length = ((Collection)val).size();
                            } else if (val.getClass().isArray()) {
                                ArrayList<Object> ar = new ArrayList<Object>();
                                length = Array.getLength(val);
                                for (int i = 0; i < length; ++i) {
                                    ar.add(Array.get(val, i));
                                }
                                it = ar;
                            }
                            if (0 == length) {
                                if (c.isNegated()) {
                                    sb.append(" IS NOT NULL OR TRUE ");
                                    break block1;
                                }
                                sb.append(" IS NULL AND FALSE ");
                                break block1;
                            }
                            if (c.isNegated()) {
                                sb.append(" NOT IN ");
                            } else {
                                sb.append(" IN ");
                            }
                            JDBC.listing(sb, it, v -> dialect.toQueryString(v));
                            break block1;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    public static void alterTableAddFields(Connection conn, Model model, SqlDialect dialect) throws SQLException {
        String table = model.getTable();
        if (!JDBC.isTableExists(conn, table)) {
            SqlTools.createTable(conn, model, dialect);
        } else {
            ArrayList<Field> toAdd = new ArrayList<Field>();
            ArrayList<String> dbf = new ArrayList<String>();
            dialect.getTableFields(conn, dbf, table);
            block9: for (Field fd : model.getFields()) {
                for (String f : dbf) {
                    if (!fd.getName().equals(f)) continue;
                    continue block9;
                }
                if (null == dialect.getSqlType(fd)) continue;
                toAdd.add(fd);
            }
            if (toAdd.size() > 0) {
                String quote = dialect.getFieldQuoteString();
                StringBuilder sb = new StringBuilder();
                sb.append("ALTER TABLE ");
                sb.append(quote);
                sb.append(table);
                sb.append(quote);
                sb.append(" ADD ");
                int n = 0;
                for (Field f : toAdd) {
                    if (n++ > 0) {
                        sb.append(", ");
                    }
                    sb.append(quote);
                    sb.append(f.getName());
                    sb.append(quote);
                    sb.append(" ");
                    sb.append(dialect.getSqlType(f));
                }
                Statement st = conn.createStatement();
                Object object = null;
                try {
                    st.execute(sb.toString());
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (st != null) {
                        if (object != null) {
                            try {
                                st.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            st.close();
                        }
                    }
                }
            }
        }
    }

    public static boolean createTable(Connection conn, Model m, SqlDialect dialect) throws SQLException {
        String quote = dialect.getFieldQuoteString();
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ");
        sb.append(quote);
        sb.append(m.getTable());
        sb.append(quote);
        sb.append(" (");
        int i = 0;
        for (Field fd : m.getFields()) {
            String type = dialect.getSqlType(fd);
            if (null == type) continue;
            if (i++ > 0) {
                sb.append(", ");
            }
            sb.append(quote);
            sb.append(fd.getName());
            sb.append(quote);
            sb.append(" ");
            sb.append(type);
        }
        sb.append(")");
        sb.append(dialect.getOtherTableCreateOptions());
        try (Statement st = conn.createStatement();){
            int n = st.execute(sb.toString()) ? 1 : 0;
            return n != 0;
        }
    }
}

