/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.database.pojodb.dialect;

import eu.javaexperience.database.JDBC;
import eu.javaexperience.database.annotations.AutoIncrement;
import eu.javaexperience.database.annotations.Ignore;
import eu.javaexperience.database.annotations.Indexed;
import eu.javaexperience.database.annotations.Length;
import eu.javaexperience.database.annotations.NotNull;
import eu.javaexperience.database.annotations.Primary;
import eu.javaexperience.database.annotations.Type;
import eu.javaexperience.database.annotations.Unique;
import eu.javaexperience.database.annotations.Unsigned;
import eu.javaexperience.database.jdbc.Id;
import eu.javaexperience.database.pojodb.dialect.SqlDialect;
import eu.javaexperience.text.Format;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Date;

public class SqliteDialect
implements SqlDialect {
    @Override
    public boolean probeDialect(Connection conn) {
        try {
            return null != JDBC.getString(conn, "select sqlite_version()");
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public String getSqlType(Field f) {
        Indexed i;
        NotNull nn;
        Ignore i2 = f.getAnnotation(Ignore.class);
        if (null != i2) {
            return null;
        }
        Class<?> a = f.getType();
        boolean notNull = false;
        String type = null;
        if (Boolean.TYPE.equals(a)) {
            notNull = true;
            type = "BOOLEAN";
        } else if (Boolean.class.equals(a)) {
            type = "BOOLEAN";
        } else if (Byte.TYPE.equals(a)) {
            notNull = true;
            type = "BINARY(1)";
        } else if (Byte.class.equals(a)) {
            type = "BINARY(1)";
        } else if (Character.TYPE.equals(a)) {
            notNull = true;
            type = "CHARACTER(1)";
        } else if (Character.class.equals(a)) {
            type = "CHARACTER(1)";
        } else if (Short.TYPE.equals(a)) {
            notNull = true;
            type = "SMALLINT";
        } else if (Short.class.equals(a)) {
            type = "SMALLINT";
        } else if (Integer.TYPE.equals(a)) {
            notNull = true;
            type = "INTEGER";
        } else if (Integer.class.equals(a)) {
            type = "INTEGER";
        } else if (Float.TYPE.equals(a)) {
            notNull = true;
            type = "FLOAT";
        } else if (Float.class.equals(a)) {
            type = "FLOAT";
        } else if (Long.TYPE.equals(a)) {
            notNull = true;
            type = "BIGINT";
        } else if (Long.class.equals(a)) {
            type = "BIGINT";
        } else if (Double.TYPE.equals(a)) {
            notNull = true;
            type = "DOUBLE PRECISION";
        } else if (Double.class.equals(a)) {
            type = "DOUBLE PRECISION";
        } else if (Date.class.isAssignableFrom(a)) {
            type = "TIMESTAMP";
        } else if (String.class.equals(a)) {
            type = null == f.getAnnotation(Length.class) ? "TEXT" : "VARCHAR";
        }
        Type t = f.getAnnotation(Type.class);
        if (null != t) {
            type = t.type();
        }
        if (null == type) {
            throw new RuntimeException("Not primitive class or Date or String: " + f);
        }
        Length l = f.getAnnotation(Length.class);
        if (null != l) {
            type = type + "(" + l.length() + ")";
        }
        if (null != (nn = f.getAnnotation(NotNull.class))) {
            notNull = true;
        }
        type = notNull || null != f.getAnnotation(Id.class) ? type + " NOT NULL" : type + " NULL";
        if (null != f.getAnnotation(Primary.class) || null != f.getAnnotation(Id.class)) {
            type = type + " PRIMARY KEY";
        }
        if (null != a.getAnnotation(AutoIncrement.class) || null != f.getAnnotation(Id.class)) {
            type = type + " AUTOINCREMENT";
        }
        if (null != f.getAnnotation(Unique.class) || null != f.getAnnotation(Id.class)) {
            type = type + " UNIQUE";
        }
        if (null != a.getAnnotation(Unsigned.class)) {
            type = type + " UNSIGNED";
        }
        if (null != (i = a.getAnnotation(Indexed.class))) {
            type = type + " INDEX(`" + f.getName() + "`)";
        }
        return type;
    }

    @Override
    public String getFieldQuoteString() {
        return "`";
    }

    @Override
    public String getStringQuote() {
        return "\"";
    }

    @Override
    public String getOtherTableCreateOptions() {
        return "";
    }

    @Override
    public void getTableFields(Connection connection, Collection<String> dbf, String table) throws SQLException {
        try (Statement st = connection.createStatement();
             ResultSet rs = st.executeQuery("PRAGMA table_info('" + table + "')");){
            while (rs.next()) {
                dbf.add(rs.getString(2));
            }
        }
    }

    @Override
    public String escapeString(String value) {
        if (null == value) {
            return "null";
        }
        return value.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    @Override
    public String toQueryString(Object o) {
        if (o instanceof Date) {
            return Format.sqlTimestamp((Date)o);
        }
        if (null != o && o.getClass().isEnum()) {
            return String.valueOf(((Enum)o).ordinal());
        }
        return this.getStringQuote() + this.escapeString(o.toString()) + this.getStringQuote();
    }
}

