/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.datareprez;

import eu.javaexperience.arrays.ArrayTools;
import eu.javaexperience.collection.map.MapTools;
import eu.javaexperience.collection.map.NullMap;
import eu.javaexperience.collection.set.ArrayListSeemsSet;
import eu.javaexperience.datareprez.DataAccessor;
import eu.javaexperience.exceptions.UnsupportedMethodException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class DataAccessorTools {
    public static DataAccessor selectAccessor(Object subject, DataAccessor ... accessors) {
        for (DataAccessor a : accessors) {
            if (!a.canHandle(subject)) continue;
            return a;
        }
        return null;
    }

    public static Map<String, Object> mixedAccessWrap(final Object subject, final DataAccessor ... accessors) {
        final DataAccessor acc = DataAccessorTools.selectAccessor(subject, accessors);
        if (null == acc) {
            return NullMap.instance;
        }
        return new AccessMap(){

            protected Object wrapRet(Object ret) {
                if (null != ret) {
                    DataAccessor acc2 = DataAccessorTools.selectAccessor(ret, accessors);
                    if (null == acc2) {
                        return ret;
                    }
                    return DataAccessorTools.mixedAccessWrap(ret, accessors);
                }
                return null;
            }

            @Override
            public int size() {
                return acc.keys(subject).length;
            }

            @Override
            public boolean isEmpty() {
                return 0 != this.size();
            }

            @Override
            public boolean containsKey(Object key) {
                return ArrayTools.contains(acc.keys(subject), key);
            }

            @Override
            public boolean containsValue(Object value) {
                return false;
            }

            @Override
            public Object get(Object key) {
                return this.wrapRet(acc.get(subject, String.valueOf(key)));
            }

            @Override
            public Object put(String key, Object value) {
                throw new UnsupportedMethodException("put");
            }

            @Override
            public Object remove(Object key) {
                throw new UnsupportedMethodException("remove");
            }

            @Override
            public void putAll(Map<? extends String, ? extends Object> m) {
                throw new UnsupportedMethodException("putAll");
            }

            @Override
            public void clear() {
                throw new UnsupportedMethodException("clear");
            }

            @Override
            public Set<String> keySet() {
                return new ArrayListSeemsSet<String>(acc.keys(subject));
            }

            @Override
            public Collection<Object> values() {
                throw new UnsupportedMethodException("values");
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                String[] keys = acc.keys(subject);
                ArrayListSeemsSet<Map.Entry<String, Object>> ret = new ArrayListSeemsSet<Map.Entry<String, Object>>();
                for (final String k : keys) {
                    ret.add(new Map.Entry<String, Object>(){

                        @Override
                        public String getKey() {
                            return k;
                        }

                        @Override
                        public Object getValue() {
                            return this.wrapRet(acc.get(subject, k));
                        }

                        @Override
                        public Object setValue(Object value) {
                            throw new UnsupportedMethodException("setValue");
                        }
                    });
                }
                return ret;
            }

            public String toString() {
                return "DataAccessorTools: " + MapTools.toStringMultiline(this.entrySet());
            }

            @Override
            public Object getOrigin() {
                return subject;
            }
        };
    }

    public static interface AccessMap
    extends Map<String, Object> {
        public Object getOrigin();
    }
}

