/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.datareprez;

import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.collection.map.BulkTransitMap;
import eu.javaexperience.collection.map.MapTools;
import eu.javaexperience.collection.map.NullMap;
import eu.javaexperience.datareprez.DataAccessor;
import eu.javaexperience.datareprez.DataCommon;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.DataReprezTools;
import eu.javaexperience.datareprez.convertFrom.DataWrapper;
import eu.javaexperience.interfaces.simple.SimpleGetFactory;
import eu.javaexperience.reflect.CastTo;
import eu.javaexperience.reflect.FieldNameDialect;
import eu.javaexperience.reflect.FieldNameDialects;
import eu.javaexperience.reflect.Mirror;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DataReprezDialectTools {
    protected static final ConcurrentMap<Class, Map<String, Map<String, Field>>> DIALECT = new ConcurrentHashMap<Class, Map<String, Map<String, Field>>>();

    protected static Map<String, Map<String, Field>> getDialect(Class cls) {
        Map ret = (Map)DIALECT.get(cls);
        if (null != ret && 0 == ret.size()) {
            return ret;
        }
        Map dialects = new BulkTransitMap();
        for (Field f : Mirror.collectClassFields(cls, false)) {
            ArrayList fnds = new ArrayList();
            CollectionTools.copyInto(f.getAnnotationsByType(FieldNameDialect.class), fnds);
            for (FieldNameDialects d : (FieldNameDialects[])f.getAnnotationsByType(FieldNameDialects.class)) {
                CollectionTools.copyInto(d.value(), fnds);
            }
            for (FieldNameDialect fnd : fnds) {
                String dial = fnd.dialect();
                String name = fnd.name();
                MapTools.ensureMapInMap(dialects, dial, SimpleGetFactory.getHashMapFactory()).put(name, f);
            }
        }
        if (0 == dialects.size()) {
            dialects = NullMap.instance;
        } else {
            HashMap add = new HashMap();
            for (Map.Entry kv : dialects.entrySet()) {
                Map in = (Map)kv.getValue();
                if (in.size() > 0) {
                    in = Collections.unmodifiableMap(in);
                }
                add.put(kv.getKey(), in);
            }
            dialects = Collections.unmodifiableMap(add);
        }
        DIALECT.put(cls, dialects);
        return dialects;
    }

    public static Map<String, Map<String, Field>> getDialectFieldsOfClass(Class<?> cls) {
        return DataReprezDialectTools.getDialect(cls);
    }

    public static DataAccessor generateFieldDialectAccessor(final String dialect) {
        return new DataAccessor(){

            @Override
            public boolean canHandle(Object subject) {
                Class<?> c = subject.getClass();
                if (c.isArray()) {
                    return false;
                }
                Map<String, Field> b = DataReprezDialectTools.getDialect(c).get(dialect);
                return null != b && 0 != b.size();
            }

            @Override
            public String[] keys(Object subject) {
                return DataReprezDialectTools.getDialect(subject.getClass()).get(dialect).keySet().toArray(Mirror.emptyStringArray);
            }

            @Override
            public Object get(Object subject, String key) {
                Field f = DataReprezDialectTools.getDialect(subject.getClass()).get(dialect).get(key);
                if (null != f) {
                    try {
                        return f.get(subject);
                    }
                    catch (Exception e) {
                        Mirror.propagateAnyway(e);
                    }
                }
                return null;
            }
        };
    }

    public static boolean fillPoJoFromDialectNaive(Object target, String dialect, DataObject data) {
        Map<String, Field> fs = DataReprezDialectTools.getDialectFieldsOfClass(target.getClass()).get(dialect);
        if (null == fs) {
            return false;
        }
        for (Map.Entry<String, Field> kv : fs.entrySet()) {
            Field f;
            CastTo c;
            Object o = data.opt(kv.getKey());
            if (null == o || null == (c = CastTo.getCasterRestrictlyForTargetClass((f = kv.getValue()).getType())) || null == (o = c.cast(o))) continue;
            try {
                f.set(target, o);
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public static boolean fillPoJoFromDialectNaive(Object target, String dialect, Map<String, Object> data) {
        Map<String, Field> fs = DataReprezDialectTools.getDialectFieldsOfClass(target.getClass()).get(dialect);
        if (null == fs) {
            return false;
        }
        for (Map.Entry<String, Field> kv : fs.entrySet()) {
            Field f;
            CastTo c;
            Object o = data.get(kv.getKey());
            if (null == o || null == (c = CastTo.getCasterRestrictlyForTargetClass((f = kv.getValue()).getType())) || null == (o = c.cast(o))) continue;
            try {
                f.set(target, o);
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public static DataWrapper generateFieldDialectWrapper(final String dialect) {
        return new DataWrapper(){

            @Override
            public DataCommon wrap(DataWrapper topWrapper, DataCommon prototype, Object o) {
                Map<String, Map<String, Field>> d = DataReprezDialectTools.getDialect(o.getClass());
                if (null == d || 0 == d.size()) {
                    return null;
                }
                Map<String, Field> di = d.get(dialect);
                if (null == di || 0 == di.size()) {
                    return null;
                }
                DataObject ret = prototype.newObjectInstance();
                for (Map.Entry<String, Field> ent : di.entrySet()) {
                    String key = ent.getKey();
                    try {
                        Object w = ent.getValue().get(o);
                        if (null == w || null != DataReprezTools.put(topWrapper, ret, key, w)) continue;
                        DataReprezTools.put(topWrapper, ret, key, (Object)topWrapper.wrap(topWrapper, prototype, w));
                    }
                    catch (Exception e) {
                        Mirror.propagateAnyway(e);
                    }
                }
                return ret;
            }
        };
    }
}

