/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.datareprez;

import eu.javaexperience.datareprez.DataAccessor;
import eu.javaexperience.datareprez.convertFrom.ArrayLike;
import eu.javaexperience.interfaces.ObjectWithProperty;
import eu.javaexperience.parse.ParsePrimitive;
import eu.javaexperience.reflect.Mirror;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public enum WellKnownDataAccessors implements DataAccessor
{
    MAP{

        @Override
        public boolean canHandle(Object subject) {
            return subject instanceof Map;
        }

        @Override
        public Object get(Object subject, String key) {
            return ((Map)subject).get(key);
        }

        @Override
        public String[] keys(Object subject) {
            return ((Map)subject).keySet().toArray(Mirror.emptyStringArray);
        }
    }
    ,
    ARRAY{

        @Override
        public boolean canHandle(Object subject) {
            return subject.getClass().isArray();
        }

        @Override
        public Object get(Object subject, String key) {
            if (null == key) {
                return null;
            }
            int len = Array.getLength(subject);
            if ("length".equals(key)) {
                return len;
            }
            if (0 == len) {
                return null;
            }
            if ("first".equals(key)) {
                return Array.get(subject, 0);
            }
            if ("last".equals(key)) {
                return Array.get(subject, len - 1);
            }
            int index = ParsePrimitive.tryParseInt(key, -1);
            if (-1 < index && index < len) {
                return Array.get(subject, index);
            }
            return null;
        }

        @Override
        public String[] keys(Object subject) {
            return 2.generateArrayKeys(Array.getLength(subject), true);
        }
    }
    ,
    LIST{

        @Override
        public boolean canHandle(Object subject) {
            return subject instanceof List;
        }

        @Override
        public Object get(Object subject, String key) {
            List s = (List)subject;
            int len = s.size();
            if ("length".equals(key)) {
                return len;
            }
            if (0 == len) {
                return null;
            }
            if ("first".equals(key)) {
                return s.get(0);
            }
            if ("last".equals(key)) {
                return s.get(len - 1);
            }
            int index = ParsePrimitive.tryParseInt(key, -1);
            if (-1 < index && index < len) {
                return s.get(index);
            }
            return null;
        }

        @Override
        public String[] keys(Object subject) {
            return 3.generateArrayKeys(((List)subject).size(), true);
        }
    }
    ,
    OBJECT_PUBLIC_FIELDS{

        @Override
        public boolean canHandle(Object subject) {
            return true;
        }

        @Override
        public Object get(Object subject, String key) {
            Map<String, Field> acc = 4.getAccessorOfClass(subject.getClass());
            Field f = acc.get(key);
            if (null != f) {
                try {
                    return f.get(subject);
                }
                catch (Exception e) {
                    Mirror.propagateAnyway(e);
                }
            }
            return null;
        }

        @Override
        public String[] keys(Object subject) {
            Map<String, Field> acc = 4.getAccessorOfClass(subject.getClass());
            return acc.keySet().toArray(Mirror.emptyStringArray);
        }
    }
    ,
    ARRAY_SIMPLEST{

        @Override
        public boolean canHandle(Object subject) {
            return subject.getClass().isArray();
        }

        @Override
        public Object get(Object subject, String key) {
            if (null == key) {
                return null;
            }
            int len = Array.getLength(subject);
            int index = ParsePrimitive.tryParseInt(key, -1);
            if (-1 < index && index < len) {
                return Array.get(subject, index);
            }
            return null;
        }

        @Override
        public String[] keys(Object subject) {
            return 5.generateArrayKeys(Array.getLength(subject), false);
        }
    }
    ,
    LIST_SIMPLEST{

        @Override
        public boolean canHandle(Object subject) {
            return subject instanceof List;
        }

        @Override
        public Object get(Object subject, String key) {
            List s = (List)subject;
            int len = s.size();
            int index = ParsePrimitive.tryParseInt(key, -1);
            if (-1 < index && index < len) {
                return s.get(index);
            }
            return null;
        }

        @Override
        public String[] keys(Object subject) {
            return 6.generateArrayKeys(((List)subject).size(), false);
        }
    }
    ,
    OBJECT_LIKE{

        @Override
        public boolean canHandle(Object subject) {
            return subject instanceof ObjectWithProperty;
        }

        @Override
        public Object get(Object subject, String key) {
            return ((ObjectWithProperty)subject).get(key);
        }

        @Override
        public String[] keys(Object subject) {
            return ((ObjectWithProperty)subject).keys();
        }
    }
    ,
    ARRAY_LIKE{

        @Override
        public boolean canHandle(Object subject) {
            return subject instanceof ArrayLike;
        }

        @Override
        public Object get(Object subject, String key) {
            return ((ArrayLike)subject).get(Integer.parseInt(key));
        }

        @Override
        public String[] keys(Object subject) {
            return 8.generateArrayKeys(((ArrayLike)subject).size(), false);
        }
    };

    protected static ConcurrentMap<Class, Map<String, Field>> classAccessors;

    public static Map<String, Field> getAccessorOfClass(Class cls) {
        Map<String, Field> ret = (HashMap)classAccessors.get(cls);
        if (null == ret) {
            Field[] fs = Mirror.collectClassFields(cls, true);
            ret = new HashMap();
            for (Field f : fs) {
                f.setAccessible(true);
                ret.put(f.getName(), f);
            }
            Map in = classAccessors.put(cls, ret = Collections.unmodifiableMap(ret));
            if (null != in) {
                ret = in;
            }
        }
        return ret;
    }

    protected static String[] generateArrayKeys(int len, boolean withExtra) {
        if (0 == len) {
            return Mirror.emptyStringArray;
        }
        String[] ret = new String[len + (withExtra ? 3 : 0)];
        for (int i = 0; i < len; ++i) {
            ret[i] = String.valueOf(i);
        }
        if (withExtra) {
            ret[len] = "first";
            ret[len + 1] = "last";
            ret[len + 2] = "length";
        }
        return ret;
    }

    static {
        classAccessors = new ConcurrentHashMap<Class, Map<String, Field>>();
    }
}

