/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.datareprez.jsonImpl;

import eu.javaexperience.collection.iterator.IteratorTools;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataCommon;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.convertFrom.DataReprezType;
import eu.javaexperience.datareprez.jsonImpl.DataArrayJsonImpl;
import eu.javaexperience.datareprez.jsonImpl.DataOperatorJsonCommon;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.text.Format;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class DataObjectJsonImpl
extends DataOperatorJsonCommon
implements DataObject {
    public static DataCommon instane = new DataObjectJsonImpl();
    final JSONObject obj;

    public DataObjectJsonImpl() {
        this.obj = new JSONObject();
    }

    public DataObjectJsonImpl(JSONObject obj) {
        this.obj = obj;
    }

    @Override
    public void putString(String key, String val) {
        this.obj.put(key, val);
    }

    @Override
    public void putLong(String key, long val) {
        this.obj.put(key, val);
    }

    @Override
    public void putDouble(String key, double val) {
        this.obj.put(key, val);
    }

    @Override
    public void putInt(String key, int val) {
        this.obj.put(key, val);
    }

    @Override
    public void putBoolean(String key, boolean val) {
        this.obj.put(key, val);
    }

    @Override
    public void putObject(String key, DataObject val) {
        this.obj.put(key, ((DataObjectJsonImpl)val).obj);
    }

    @Override
    public void putNull(String key) {
        this.obj.put(key, JSONObject.NULL);
    }

    @Override
    public void putArray(String key, DataArray val) {
        this.obj.put(key, ((DataArrayJsonImpl)val).arr);
    }

    @Override
    public String getString(String key) {
        return this.obj.getString(key);
    }

    @Override
    public long getLong(String key) {
        return this.obj.getLong(key);
    }

    @Override
    public double getDouble(String key) {
        return this.obj.getDouble(key);
    }

    @Override
    public int getInt(String key) {
        return this.obj.getInt(key);
    }

    @Override
    public boolean getBoolean(String key) {
        return this.obj.getBoolean(key);
    }

    @Override
    public DataObject getObject(String key) {
        return new DataObjectJsonImpl(this.obj.getJSONObject(key));
    }

    @Override
    public DataArray getArray(String key) {
        return new DataArrayJsonImpl(this.obj.getJSONArray(key));
    }

    @Override
    public String optString(String key) {
        if (!this.obj.has(key)) {
            return null;
        }
        return this.obj.optString(key);
    }

    @Override
    public Long optLong(String key) {
        if (!this.obj.has(key)) {
            return null;
        }
        return this.obj.optLong(key);
    }

    @Override
    public Double optDouble(String key) {
        if (!this.obj.has(key)) {
            return null;
        }
        return this.obj.optDouble(key);
    }

    @Override
    public Integer optInt(String key) {
        if (!this.obj.has(key)) {
            return null;
        }
        return this.obj.optInt(key);
    }

    @Override
    public Boolean optBoolean(String key) {
        if (!this.obj.has(key)) {
            return null;
        }
        return this.obj.optBoolean(key);
    }

    @Override
    public DataObject optObject(String key) {
        JSONObject o = this.obj.optJSONObject(key);
        if (o == null) {
            return null;
        }
        return new DataObjectJsonImpl(o);
    }

    @Override
    public DataArray optArray(String key) {
        JSONArray o = this.obj.optJSONArray(key);
        if (o == null) {
            return null;
        }
        return new DataArrayJsonImpl(o);
    }

    @Override
    public String optString(String key, String def) {
        return this.obj.optString(key, def);
    }

    @Override
    public long optLong(String key, long def) {
        return this.obj.optLong(key, def);
    }

    @Override
    public double optDouble(String key, double val) {
        return this.obj.optDouble(key, val);
    }

    @Override
    public int optInt(String key, int def) {
        return this.obj.optInt(key, def);
    }

    @Override
    public boolean optBoolean(String key, boolean def) {
        return this.obj.optBoolean(key, def);
    }

    @Override
    public DataObject optObject(String key, DataObject def) {
        JSONObject o = this.obj.optJSONObject(key);
        if (o == null) {
            return def;
        }
        return new DataObjectJsonImpl(o);
    }

    @Override
    public DataArray optArray(String key, DataArray def) {
        JSONArray a = this.obj.optJSONArray(key);
        if (a == null) {
            return def;
        }
        return new DataArrayJsonImpl(a);
    }

    @Override
    public boolean has(String key) {
        return this.obj.has(key);
    }

    @Override
    public String[] keys() {
        return this.obj.keySet().toArray(Mirror.emptyStringArray);
    }

    @Override
    public int size() {
        return this.obj.keySet().size();
    }

    @Override
    public boolean isString(String key) {
        return this.obj.optString(key) != null;
    }

    @Override
    public boolean isLong(String key) {
        return Long.class.equals(this.obj.get(key).getClass());
    }

    @Override
    public boolean isDouble(String key) {
        return Double.class.equals(this.obj.get(key).getClass());
    }

    @Override
    public boolean isInt(String key) {
        return Integer.class.equals(this.obj.get(key).getClass());
    }

    @Override
    public boolean isBoolean(String key) {
        return Boolean.class.equals(this.obj.get(key).getClass());
    }

    @Override
    public boolean isObject(String key) {
        return this.obj.get(key) instanceof JSONObject;
    }

    @Override
    public boolean isArray(String key) {
        return this.obj.get(key) instanceof JSONArray;
    }

    @Override
    public boolean isNull(String key) {
        return this.obj.isNull(key);
    }

    @Override
    public Object get(String key) {
        Object o = this.obj.get(key);
        if (o instanceof JSONObject) {
            return new DataObjectJsonImpl((JSONObject)o);
        }
        if (o instanceof JSONArray) {
            return new DataArrayJsonImpl((JSONArray)o);
        }
        return o;
    }

    @Override
    public Object opt(String key) {
        Object o = this.obj.opt(key);
        if (o instanceof JSONObject) {
            return new DataObjectJsonImpl((JSONObject)o);
        }
        if (o instanceof JSONArray) {
            return new DataArrayJsonImpl((JSONArray)o);
        }
        return o;
    }

    @Override
    public Object opt(String key, Object obj) {
        Object o = this.obj.opt(key);
        if (o == null) {
            return obj;
        }
        if (o instanceof JSONObject) {
            return new DataObjectJsonImpl((JSONObject)o);
        }
        if (o instanceof JSONArray) {
            return new DataArrayJsonImpl((JSONArray)o);
        }
        return o;
    }

    @Override
    public Map<String, Object> asJavaMap() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (String k : IteratorTools.wrapIterator(this.obj.keys())) {
            Object curr = this.obj.get(k);
            if (this.isNull(curr)) {
                ret.put(k, null);
                continue;
            }
            if (curr instanceof JSONArray) {
                ret.put(k, new DataArrayJsonImpl((JSONArray)curr).asJavaArray());
                continue;
            }
            if (curr instanceof JSONObject) {
                ret.put(k, new DataObjectJsonImpl((JSONObject)curr).asJavaMap());
                continue;
            }
            if (curr instanceof DataArray) {
                ret.put(k, ((DataArray)curr).asJavaArray());
                continue;
            }
            if (curr instanceof DataObject) {
                ret.put(k, ((DataObject)curr).asJavaMap());
                continue;
            }
            ret.put(k, curr);
        }
        return ret;
    }

    @Override
    public void putBlob(String key, byte[] blob) {
        this.obj.put(key, Format.base64Encode(blob));
    }

    @Override
    public byte[] getBlob(String key) {
        return Format.base64Decode(this.obj.getString(key));
    }

    @Override
    public byte[] optBlob(String key) {
        try {
            return Format.base64Decode(this.obj.getString(key));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public byte[] optBlob(String key, byte[] blob) {
        try {
            return Format.base64Decode(this.obj.getString(key));
        }
        catch (Exception e) {
            return blob;
        }
    }

    @Override
    public boolean isBlob(String key) {
        try {
            Format.base64Decode(this.obj.getString(key));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Object getImpl() {
        return this.obj;
    }

    @Override
    public void remove(String key) {
        this.obj.remove(key);
    }

    @Override
    public DataReprezType getDataReprezType() {
        return DataReprezType.OBJECT;
    }

    @Override
    public byte[] toBlob() {
        return this.obj.toString().getBytes();
    }

    public String toString() {
        return "DataObjectJsonImpl: " + this.obj;
    }
}

