/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.datastorage;

import eu.javaexperience.datastorage.DataStorage;
import eu.javaexperience.datastorage.DataTransaction;
import eu.javaexperience.datastorage.TransactionException;
import eu.javaexperience.reflect.Mirror;
import java.io.IOException;

public abstract class TransactionHandler<T> {
    protected int retry;
    protected DataStorage storage;
    protected String key;

    public TransactionHandler(DataStorage storage, String key, int retry) {
        this.storage = storage;
        this.key = key;
        this.retry = retry;
    }

    protected abstract T doExecute(DataTransaction var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T execute() {
        int retryCount = 0;
        while (true) {
            DataTransaction tr = this.storage.startTransaction(this.key);
            try {
                T ret = this.doExecute(tr);
                tr.commit();
                T t = ret;
                return t;
            }
            catch (TransactionException ex) {
                if (null != tr) {
                    tr.rollback();
                }
                if (retryCount++ != this.retry) continue;
                Mirror.propagateAnyway(ex);
                continue;
            }
            catch (Exception e) {
                Mirror.propagateAnyway(e);
                continue;
            }
            finally {
                if (null == tr) continue;
                try {
                    tr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            break;
        }
    }
}

