/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.datastorage.sql;

import eu.javaexperience.collection.map.MappedMap;
import eu.javaexperience.database.JDBC;
import eu.javaexperience.database.collection.JdbcMap;
import eu.javaexperience.datastorage.DataTransaction;
import eu.javaexperience.datastorage.TransactionException;
import eu.javaexperience.datastorage.sql.SqlDataStorage;
import eu.javaexperience.interfaces.simple.WrapUnwarpTools;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.text.StringTools;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class SqlDataTransaction
implements DataTransaction {
    protected SqlDataStorage storage;
    protected String key;
    Connection conn;
    protected Map<String, Object> map;

    public SqlDataTransaction(SqlDataStorage sqlDataStorage, String key) throws SQLException {
        this.storage = sqlDataStorage;
        this.conn = sqlDataStorage.pool.getConnection();
        this.conn.setAutoCommit(false);
        this.conn.setTransactionIsolation(8);
        this.key = key;
        this.map = new MappedMap<String, Object>(new JdbcMap<String, Object>(sqlDataStorage.access.getBy(this.conn)), StringTools.isNullOrTrimEmpty(key) ? WrapUnwarpTools.noWrap : WrapUnwarpTools.withPrefix(key + "."));
    }

    @Override
    public int size() {
        try {
            return this.map.size();
        }
        catch (Exception e) {
            this.checkException(e);
            return -1;
        }
    }

    protected void checkException(Exception ex) {
        if (null != ex) {
            SQLException e = null;
            if (ex instanceof SQLException) {
                e = (SQLException)ex;
            } else if (ex.getCause() instanceof SQLException) {
                e = (SQLException)ex.getCause();
            }
            if (null != e && JDBC.isCommitFailed(e)) {
                throw new TransactionException("Modification beneath transaction.");
            }
            Mirror.propagateAnyway(ex);
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            return this.map.isEmpty();
        }
        catch (Exception e) {
            this.checkException(e);
            return false;
        }
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            return this.map.containsKey(key);
        }
        catch (Exception e) {
            this.checkException(e);
            return false;
        }
    }

    @Override
    public boolean containsValue(Object value) {
        try {
            return this.map.containsValue(StringTools.toStringOrNull(value));
        }
        catch (Exception e) {
            this.checkException(e);
            return false;
        }
    }

    @Override
    public Object get(Object key) {
        try {
            return this.map.get(key);
        }
        catch (Exception e) {
            this.checkException(e);
            return -1;
        }
    }

    @Override
    public Object put(String key, Object value) {
        try {
            return this.map.put(key, StringTools.toStringOrNull(value));
        }
        catch (Exception e) {
            this.checkException(e);
            return -1;
        }
    }

    @Override
    public Object remove(Object key) {
        try {
            return this.map.remove(key);
        }
        catch (Exception e) {
            this.checkException(e);
            return -1;
        }
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        try {
            this.map.putAll(m);
        }
        catch (Exception e) {
            this.checkException(e);
        }
    }

    @Override
    public void clear() {
        try {
            this.map.clear();
        }
        catch (Exception e) {
            this.checkException(e);
        }
    }

    @Override
    public Set<String> keySet() {
        try {
            return this.map.keySet();
        }
        catch (Exception e) {
            this.checkException(e);
            return null;
        }
    }

    @Override
    public Collection<Object> values() {
        try {
            return this.map.values();
        }
        catch (Exception e) {
            this.checkException(e);
            return null;
        }
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        try {
            return this.map.entrySet();
        }
        catch (Exception e) {
            this.checkException(e);
            return null;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.conn.rollback();
            this.conn.setAutoCommit(true);
        }
        catch (SQLException e) {
            Mirror.propagateAnyway(e);
        }
        finally {
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                Mirror.propagateAnyway(e);
            }
        }
    }

    @Override
    public void commit() throws TransactionException {
        try {
            this.conn.commit();
        }
        catch (SQLException e) {
            if (JDBC.isCommitFailed(e)) {
                throw new TransactionException("Modification beneath transaction.");
            }
            Mirror.propagateAnyway(e);
        }
    }

    @Override
    public void rollback() {
        try {
            this.conn.rollback();
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
    }
}

