/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.file.fs.os.dir;

import eu.javaexperience.file.AbstractFile;
import eu.javaexperience.file.AbstractFileSystem;
import eu.javaexperience.file.fs.os.dir.OsDirectoryFilesystem;
import eu.javaexperience.io.file.FileTools;
import eu.javaexperience.text.StringTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class OsDirectoryFile
implements AbstractFile {
    protected OsDirectoryFilesystem dfs;
    protected String file;

    public OsDirectoryFile(OsDirectoryFilesystem dfs, String file) {
        this.dfs = dfs;
        this.file = FileTools.normalizeSlashes(file);
    }

    @Override
    public String getUrl() {
        return this.file;
    }

    @Override
    public String getFileName() {
        String ret = StringTools.getSubstringAfterLastString(this.file, "/");
        if (ret.length() == 0) {
            ret = StringTools.getSubstringBeforeLastString(this.file, "/");
            ret = StringTools.getSubstringAfterFirstString(ret, "/");
        }
        return ret;
    }

    @Override
    public AbstractFileSystem getFileSystem() {
        return this.dfs;
    }

    protected String unwrap(File c) {
        String root;
        if (null == c) {
            return null;
        }
        String cs = c.toString();
        if (!cs.startsWith(root = this.dfs.root.toString())) {
            return null;
        }
        return StringTools.getSubstringAfterFirstString(c.toString(), root, null);
    }

    @Override
    public AbstractFile getCanonicalFile() throws IOException {
        String ret = this.unwrap(new File(this.dfs.root + "/" + this.file).getCanonicalFile());
        if (null == ret) {
            return null;
        }
        return new OsDirectoryFile(this.dfs, ret);
    }

    protected File asFile() {
        return new File(this.dfs.root.toString() + "/" + this.file);
    }

    @Override
    public boolean delete() throws IOException {
        return this.asFile().delete();
    }

    @Override
    public long lastModified() {
        return this.asFile().lastModified();
    }

    @Override
    public boolean setLastModified(long time) throws IOException {
        return this.asFile().setLastModified(time);
    }

    @Override
    public boolean exists() {
        return this.asFile().exists();
    }

    @Override
    public boolean createNewRegularFile() throws IOException {
        return this.asFile().createNewFile();
    }

    @Override
    public boolean isRegularFile() {
        return this.asFile().isFile();
    }

    @Override
    public long getSize() {
        return this.asFile().length();
    }

    @Override
    public boolean isDirectory() {
        return this.asFile().isDirectory();
    }

    @Override
    public AbstractFile[] listFiles() {
        File[] fs = this.asFile().listFiles();
        if (null == fs) {
            return null;
        }
        AbstractFile[] ret = new AbstractFile[fs.length];
        int l = 0;
        for (int i = 0; i < ret.length; ++i) {
            String add = this.unwrap(fs[i]);
            if (null == add) continue;
            ret[l++] = new OsDirectoryFile(this.dfs, add);
        }
        if (ret.length == l) {
            return ret;
        }
        return Arrays.copyOf(ret, l);
    }

    @Override
    public boolean mkdir() throws IOException {
        return this.asFile().mkdir();
    }

    @Override
    public boolean mkdirs() throws IOException {
        return this.asFile().mkdirs();
    }

    @Override
    public boolean canRead() {
        return this.asFile().canRead();
    }

    @Override
    public boolean canWrite() {
        return this.asFile().canWrite();
    }

    @Override
    public InputStream openRead() throws IOException {
        return new FileInputStream(this.asFile());
    }

    @Override
    public OutputStream openWrite(boolean append) throws IOException {
        return new FileOutputStream(this.asFile(), append);
    }

    @Override
    public AbstractFile getParentFile() {
        String f = null;
        f = this.file.endsWith("/") ? StringTools.getLastBetween(this.file, "/", "/", null) : StringTools.getSubstringAfterLastString(this.file, "/", null);
        if (null == f) {
            return null;
        }
        return new OsDirectoryFile(this.dfs, f);
    }

    @Override
    public long createTime() {
        return 0L;
    }
}

