/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.functional;

import eu.javaexperience.annotation.FunctionDescription;
import eu.javaexperience.annotation.FunctionVariableDescription;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class GeneralFunctions {
    @FunctionDescription(functionDescription="N szeri ism\u00e9telt v\u00e9grehajt\u00e1s", parameters={@FunctionVariableDescription(description="Ism\u00e9tl\u00e9sek sz\u00e1ma", mayNull=false, paramName="N", type=Object.class), @FunctionVariableDescription(description="M\u0171veletek", mayNull=false, paramName="ops", type=Object.class)}, returning=@FunctionVariableDescription(description="\u00d6sszefog\u00f3 1 db m\u0171velet", mayNull=false, paramName="", type=Object.class))
    public static SimplePublish1<Map<String, Object>> repeatTimes(final int times, final SimplePublish1<Map<String, Object>> ... ops) {
        return new SimplePublish1<Map<String, Object>>(){

            @Override
            public void publish(Map<String, Object> a) {
                for (int i = 0; i < times; ++i) {
                    for (SimplePublish1 op : ops) {
                        op.publish(a);
                    }
                }
            }
        };
    }

    protected static int getStorageSize(Object o) {
        if (null == o) {
            return 0;
        }
        if (o instanceof Collection) {
            return ((Collection)o).size();
        }
        if (o instanceof Map) {
            return ((Map)o).size();
        }
        if (o.getClass().isArray()) {
            return Array.getLength(o);
        }
        return 0;
    }

    public static SimplePublish1<Map<String, Object>> repeatUntilStorageSizeNotChange(final String storage_under_key, final SimplePublish1<Map<String, Object>> ... ops) {
        return new SimplePublish1<Map<String, Object>>(){

            @Override
            public void publish(Map<String, Object> a) {
                Object storage = a.get(storage_under_key);
                int prev = GeneralFunctions.getStorageSize(storage);
                int crnt = 0;
                do {
                    prev = crnt;
                    for (SimplePublish1 op : ops) {
                        op.publish(a);
                    }
                } while (prev != (crnt = GeneralFunctions.getStorageSize(storage)));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R, P> void do_parallel(final SimplePublish1<R> put_result, Collection<P> src_coll_get, final GetBy1<R, P> process_single, int concurrency) {
        final LinkedBlockingQueue<P> urls_queue = new LinkedBlockingQueue<P>();
        urls_queue.addAll(src_coll_get);
        final AtomicInteger nums = new AtomicInteger(concurrency);
        for (int i = 0; i < concurrency; ++i) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Object todo = null;
                        while (true) {
                            Object e = urls_queue.poll();
                            todo = e;
                            if (null != e) {
                                put_result.publish(process_single.getBy(todo));
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    AtomicInteger atomicInteger = nums;
                    synchronized (atomicInteger) {
                        nums.decrementAndGet();
                        nums.notifyAll();
                    }
                }
            }.start();
        }
        AtomicInteger atomicInteger = nums;
        synchronized (atomicInteger) {
            while (0 != nums.get()) {
                try {
                    nums.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @FunctionDescription(functionDescription="M\u0171veletek soros v\u00e9grehaj\u00e1sa", parameters={@FunctionVariableDescription(description="M\u0171veletek", mayNull=false, paramName="sequence", type=Object.class)}, returning=@FunctionVariableDescription(description="\u00d6sszefog\u00f3 1 db m\u0171velet", mayNull=false, paramName="", type=Object.class))
    public static SimplePublish1<Map<String, Object>> sequence(final SimplePublish1<Map<String, Object>> ... seq) {
        return new SimplePublish1<Map<String, Object>>(){

            @Override
            public void publish(Map<String, Object> a) {
                for (SimplePublish1 s : seq) {
                    if (null == s) continue;
                    s.publish(a);
                }
            }
        };
    }

    public static <T> SimplePublish1<Map<String, Object>> assign(final String name, final T value) {
        return new SimplePublish1<Map<String, Object>>(){

            @Override
            public void publish(Map<String, Object> a) {
                a.put(name, value);
            }
        };
    }

    @FunctionDescription(functionDescription="Az els\u0151 nem null \u00e9rt\u00e9k felhaszn\u00e1l\u00e1sa", parameters={@FunctionVariableDescription(description="\u00c9rt\u00e9kek", mayNull=false, paramName="sequence", type=Object.class)}, returning=@FunctionVariableDescription(description="els\u0151 nem null \u00e9rt\u00e9k", mayNull=false, paramName="", type=Object.class))
    public static <T> T firstNonNull(T ... values) {
        for (T v : values) {
            if (null == v) continue;
            return v;
        }
        return null;
    }
}

