/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.image;

import eu.javaexperience.image.ImageTools;
import eu.javaexperience.swing.SwingTools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;

public class ImageDisplayWindow {
    protected JFrame frame = new JFrame(){
        public static final long serialVersionUID = 1L;

        @Override
        public void paint(Graphics g) {
            if (null == ImageDisplayWindow.this.image) {
                return;
            }
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (ImageDisplayWindow.this.autoscaleImage) {
                Dimension dim = ImageTools.calculateResizeKeepRatioFitIn(ImageDisplayWindow.this.image.getWidth(), ImageDisplayWindow.this.image.getHeight(), this.getWidth(), this.getHeight());
                g.drawImage(ImageDisplayWindow.this.image, 0, 30, (int)dim.getWidth(), (int)dim.getHeight() + 30, null);
            } else {
                g.drawImage(ImageDisplayWindow.this.image, 0, 30, null);
            }
        }
    };
    protected BufferedImage image;
    protected boolean autoscaleImage = true;

    public ImageDisplayWindow() {
        this.frame.setSize(300, 300);
    }

    public void show() {
        this.frame.setVisible(true);
    }

    public void setBufferedImage(BufferedImage image) {
        this.image = image;
        SwingTools.realRepaint(this.frame);
    }
}

