/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.image;

import eu.javaexperience.math.MathTools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;

public class ImageTools {
    public static BufferedImage resize(BufferedImage img, int newW, int newH) {
        if (img.getWidth() == newW && img.getHeight() == newH) {
            return img;
        }
        int w = img.getWidth();
        int h = img.getHeight();
        BufferedImage dimg = new BufferedImage(newW, newH, img.getType());
        Graphics2D g = dimg.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(img, 0, 0, newW, newH, 0, 0, w, h, null);
        g.dispose();
        return dimg;
    }

    public static int calculateResizeKeepRatio(int width, int height, boolean isGivenWidth, int newSize) {
        double ratio = (double)width / (double)height;
        if (isGivenWidth) {
            return (int)((double)newSize / ratio);
        }
        return (int)((double)newSize * ratio);
    }

    public static Dimension calculateResizeKeepRatioFitIn(int width, int height, int newWidth, int newHeight) {
        int nw = newWidth;
        int nh = ImageTools.calculateResizeKeepRatio(width, height, true, newWidth);
        if (nh > newHeight) {
            nh = newHeight;
            nw = ImageTools.calculateResizeKeepRatio(width, height, false, newHeight);
        }
        return new Dimension(nw, nh);
    }

    protected static Dimension calculateResizeKeepRatioFitInCheck(int width, int height, int newWidth, int newHeight) {
        Dimension ret = ImageTools.calculateResizeKeepRatioFitIn(width, height, newWidth, newHeight);
        if ((double)newWidth < ret.getWidth() || (double)newHeight < ret.getHeight() || !MathTools.inRange((double)width / (double)height, ret.getWidth() / ret.getHeight(), 0.01)) {
            System.out.println("Resize mismatch: " + newWidth + " " + newHeight + " " + ret);
        }
        return ret;
    }

    public static void main(String[] args) {
        ImageTools.calculateResizeKeepRatioFitInCheck(1024, 768, 100, 1000);
        ImageTools.calculateResizeKeepRatioFitInCheck(1024, 768, 1000, 100);
        ImageTools.calculateResizeKeepRatioFitInCheck(768, 1024, 100, 1000);
        ImageTools.calculateResizeKeepRatioFitInCheck(768, 1024, 1000, 100);
        ImageTools.calculateResizeKeepRatioFitInCheck(1000, 100, 100, 1000);
        ImageTools.calculateResizeKeepRatioFitInCheck(1000, 100, 1000, 100);
        ImageTools.calculateResizeKeepRatioFitInCheck(100, 1000, 100, 1000);
        ImageTools.calculateResizeKeepRatioFitInCheck(100, 1000, 1000, 100);
    }

    public static JFrame guiShowimage(String title, final BufferedImage br, boolean exitOnClose, final boolean scaleImage) {
        JFrame ret = new JFrame(){
            public static final long serialVersionUID = 1L;

            @Override
            public void paint(Graphics g) {
                if (scaleImage) {
                    Dimension dim = ImageTools.calculateResizeKeepRatioFitIn(br.getWidth(), br.getHeight(), this.getWidth(), this.getHeight());
                    g.setColor(Color.WHITE);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g.drawImage(br, 0, 30, (int)dim.getWidth(), (int)dim.getHeight() + 30, null);
                } else {
                    g.drawImage(br, 0, 30, null);
                }
            }
        };
        ret.setTitle(title);
        ret.setSize(br.getWidth(), br.getHeight() + 30);
        if (exitOnClose) {
            ret.setDefaultCloseOperation(3);
        } else {
            ret.setDefaultCloseOperation(2);
        }
        ret.setVisible(true);
        return ret;
    }

    public static BufferedImage imageToGrey(BufferedImage bi) {
        return ImageTools.imageToType(bi, 10);
    }

    public static BufferedImage imageToType(BufferedImage bi, int BufferedImage_dot_Type) {
        BufferedImage image = new BufferedImage(bi.getWidth(), bi.getHeight(), BufferedImage_dot_Type);
        image.getGraphics().drawImage(bi, 0, 0, bi.getWidth(), bi.getHeight(), null);
        return image;
    }

    public static BufferedImage copy(BufferedImage bi) {
        BufferedImage ret = new BufferedImage(bi.getWidth(), bi.getHeight(), bi.getType());
        ret.getGraphics().drawImage(bi, 0, 0, null);
        return ret;
    }
}

