/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.image;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class TextToImageRender {
    protected final int lineHeight;
    protected final int charWidth;
    protected int fontSize;

    protected Font getFont() {
        return new Font("Monospaced", 0, this.fontSize);
    }

    public TextToImageRender(int fontSize) {
        this.fontSize = fontSize;
        BufferedImage IM = new BufferedImage(1, 1, 10);
        IM.getGraphics().setFont(this.getFont());
        this.lineHeight = IM.getGraphics().getFontMetrics().getHeight();
        this.charWidth = (int)((double)fontSize * 0.5);
    }

    public void renderText(String dstFile, String format, String text) throws IOException {
        String[] lines = text.split("\n");
        int maxWidth = 0;
        int maxHeight = (lines.length + 1) * this.lineHeight;
        for (String s : lines) {
            maxWidth = Math.max(maxWidth, s.length());
        }
        BufferedImage image = new BufferedImage(maxWidth *= this.charWidth + 1, maxHeight, 10);
        Graphics g = image.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, maxWidth, maxHeight);
        g.setColor(Color.BLACK);
        image.getGraphics().setFont(this.getFont());
        for (int lineCount = 0; lineCount < lines.length; ++lineCount) {
            int lineOffset = (lineCount + 1) * this.lineHeight;
            String line = lines[lineCount];
            for (int i = 0; i < line.length(); ++i) {
                g.drawString(String.valueOf(line.charAt(i)), this.charWidth * i, lineOffset);
            }
        }
        g.dispose();
        int maxX = 0;
        int maxY = 0;
        for (int w = 0; w < maxWidth; ++w) {
            for (int h = 0; h < maxHeight; ++h) {
                int px = image.getRGB(w, h);
                if (255 == (px & 0xFF)) continue;
                maxX = Math.max(maxX, w);
                maxY = Math.max(maxY, h);
            }
        }
        BufferedImage img = image.getSubimage(0, 0, Math.min(maxX + this.charWidth, image.getWidth()), Math.min(maxY + this.lineHeight, image.getHeight()));
        ImageIO.write((RenderedImage)img, format, new File(dstFile));
    }
}

