/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.interfaces.simple;

import eu.javaexperience.interfaces.simple.WrapUnwrap;
import eu.javaexperience.text.StringTools;

public class WrapUnwarpTools {
    public static WrapUnwrap<String, String> noWrap = new WrapUnwrap<String, String>(){

        @Override
        public String wrap(String b) {
            return b;
        }

        @Override
        public String unwrap(String w) {
            return w;
        }
    };

    public static WrapUnwrap<String, String> withPrefix(final String prefix) {
        return new WrapUnwrap<String, String>(){

            @Override
            public String wrap(String b) {
                return prefix + b;
            }

            @Override
            public String unwrap(String w) {
                if (!w.startsWith(prefix)) {
                    return null;
                }
                return StringTools.getSubstringAfterFirstString(w, prefix, null);
            }
        };
    }

    public static <F, T> WrapUnwrap<T, F> inverse(final WrapUnwrap<F, T> wu) {
        return new WrapUnwrap<T, F>(){

            @Override
            public T wrap(F b) {
                return wu.unwrap(b);
            }

            @Override
            public F unwrap(T w) {
                return wu.wrap(w);
            }
        };
    }

    public static <F, I, T> WrapUnwrap<T, F> chain(final WrapUnwrap<I, F> first, final WrapUnwrap<T, I> last) {
        return new WrapUnwrap<T, F>(){

            @Override
            public T wrap(F b) {
                return last.wrap(first.wrap(b));
            }

            @Override
            public F unwrap(T w) {
                return first.unwrap(last.unwrap(w));
            }
        };
    }

    public static void main(String[] args) {
        String url = "https://site.tld/dir/file.ext";
        String ret = "/home/user/download/dir/file.ext";
        WrapUnwrap<String, String> c = WrapUnwarpTools.chain(WrapUnwarpTools.inverse(WrapUnwarpTools.withPrefix("https://site.tld")), WrapUnwarpTools.withPrefix("/home/user/download"));
        System.out.println(c.wrap(url));
    }
}

