/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.io;

import java.io.IOException;
import java.io.InputStream;

public class CloseSensitiveInputStream
extends InputStream {
    protected final InputStream origin;
    protected boolean isClosed = false;

    protected void closed() {
        this.isClosed = true;
    }

    public CloseSensitiveInputStream(InputStream is) {
        this.origin = is;
    }

    @Override
    public int read() throws IOException {
        try {
            return this.origin.read();
        }
        catch (IOException ex) {
            this.closed();
            throw ex;
        }
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        try {
            return this.origin.read(bytes);
        }
        catch (IOException ex) {
            this.closed();
            throw ex;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            return this.origin.read(b, off, len);
        }
        catch (IOException ex) {
            this.closed();
            throw ex;
        }
    }

    public InputStream getOrigin() {
        return this.origin;
    }

    @Override
    public int available() throws IOException {
        return this.origin.available();
    }

    @Override
    public void close() throws IOException {
        this.closed();
        this.origin.close();
    }

    @Override
    public long skip(long skip) throws IOException {
        return this.origin.skip(skip);
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.origin.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.origin.reset();
    }
}

