/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.io;

import java.io.IOException;
import java.io.OutputStream;

public class CloseSensitiveOutputStream
extends OutputStream {
    private final OutputStream origin;
    private boolean isClosed = false;

    public CloseSensitiveOutputStream(OutputStream out) {
        this.origin = out;
    }

    @Override
    public void write(int arg0) throws IOException {
        try {
            this.origin.write(arg0);
        }
        catch (IOException ex) {
            this.isClosed = true;
            throw ex;
        }
    }

    @Override
    public void close() throws IOException {
        this.origin.close();
    }

    @Override
    public void flush() throws IOException {
        this.origin.flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            this.origin.write(b);
        }
        catch (IOException ex) {
            this.isClosed = true;
            throw ex;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.origin.write(b, off, len);
        }
        catch (IOException ex) {
            this.isClosed = true;
            throw ex;
        }
    }

    public OutputStream getOrigin() {
        return this.origin;
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

