/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.io;

import eu.javaexperience.io.DirectoryContentBasedMap;
import eu.javaexperience.io.SerializationTools;
import eu.javaexperience.parse.ParsePrimitive;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FileContentMapper<T extends Serializable>
extends DirectoryContentBasedMap<T> {
    public FileContentMapper(File directory) throws FileNotFoundException {
        super(directory);
    }

    @Override
    protected T readValue(File dst, int i) {
        if (null == dst || !dst.exists()) {
            return null;
        }
        return (T)SerializationTools.deserializeFromFile(dst);
    }

    @Override
    protected void saveValue(File f, int i, T value) {
        SerializationTools.serializeIntoFile(f, value);
    }

    public static FileContentMapper<?> silentOpenOrRuntimeException(File file) {
        try {
            return new FileContentMapper(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized Set<Map.Entry<String, T>> entrySet() {
        HashSet<Map.Entry<String, T>> ret = new HashSet<Map.Entry<String, T>>();
        for (String f : this.dir.list()) {
            Integer val = ParsePrimitive.tryParseInt(f);
            if (null == val) continue;
            ret.add(new DirectoryContentBasedMap.LazyKV(this, val));
        }
        return ret;
    }
}

