/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.io;

import eu.javaexperience.file.AbstractFile;
import eu.javaexperience.file.FileSystemTools;
import eu.javaexperience.interfaces.simple.SimpleCall;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.semantic.references.MayNotModified;
import eu.javaexperience.text.StringTools;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;

public class IOTools {
    @MayNotModified
    static final byte[] unixLineFeed = new byte[]{10};
    @MayNotModified
    static final byte[] windowsLineFeed = new byte[]{13};
    @MayNotModified
    static final byte[] macLineFeed = new byte[]{13, 10};
    public static final OutputStream nullOutputStream = new OutputStream(){

        @Override
        public void write(int arg0) throws IOException {
        }

        @Override
        public void write(byte[] b) throws IOException {
        }

        @Override
        public void write(byte[] b, int i, int a) throws IOException {
        }
    };
    public static Writer nullWriter = new Writer(){

        @Override
        public void write(char[] paramArrayOfChar, int paramInt1, int paramInt2) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    };
    public static PrintWriter nullPrintWriter = new PrintWriter(nullOutputStream);
    public static final InputStream nullInputStream = new InputStream(){

        @Override
        public int read() throws IOException {
            return -1;
        }
    };

    public static byte[] loadFileContent(String file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] ret;
            byte[] byArray = ret = IOTools.loadAllAvailableFromInputStream(fis);
            return byArray;
        }
    }

    public static byte[] loadFileContent(AbstractFile file) throws IOException {
        try (InputStream fis = file.openRead();){
            byte[] byArray = IOTools.loadAllFromInputStream(fis);
            return byArray;
        }
    }

    public static byte[] loadFileProcContent(String file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] ret;
            byte[] byArray = ret = IOTools.loadAllFromInputStream(fis);
            return byArray;
        }
    }

    public static byte[] getBytesOfFile(String file, int start, int end) throws FileNotFoundException, IOException {
        if (end <= start) {
            return new byte[0];
        }
        try (FileInputStream fis = new FileInputStream(file);){
            if (end > fis.available()) {
                end = fis.available();
            }
            if (end <= start) {
                byte[] byArray = new byte[]{};
                return byArray;
            }
            byte[] ret = new byte[end - start];
            fis.skip(start);
            int ep = 0;
            int read = 0;
            while ((read = fis.read(ret, ep, ret.length - ep)) > 0) {
                ep += read;
            }
            byte[] byArray = ret;
            return byArray;
        }
    }

    public static byte[] loadFromStream(InputStream is, int len) throws FileNotFoundException, IOException {
        if (len <= 0) {
            return new byte[0];
        }
        byte[] ret = new byte[len];
        int ep = 0;
        int read = 0;
        while ((read = is.read(ret, ep, ret.length - ep)) > 0) {
            ep += read;
        }
        return ret;
    }

    public static void putFileContent(String file, byte[] data) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(data);
            fos.flush();
        }
    }

    public static void putFileContent(String file, boolean append, byte[] data) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file, append);){
            fos.write(data);
            fos.flush();
        }
    }

    public static void putFileContents(String file, boolean append, byte[] ... datas) throws FileNotFoundException, IOException {
        File f = new File(file);
        if (!f.exists()) {
            f.createNewFile();
        }
        try (FileOutputStream fos = new FileOutputStream(file, append);){
            for (byte[] data : datas) {
                fos.write(data);
            }
            fos.flush();
        }
    }

    public static byte[] loadAllAvailableFromInputStream(InputStream is) throws IOException {
        int ep = 0;
        byte[] ret = new byte[is.available()];
        while (is.available() > 0) {
            if (ep == ret.length) {
                ret = Arrays.copyOf(ret, ret.length * 2);
            }
            ep += is.read(ret, 0, ret.length - ep);
        }
        return Arrays.copyOf(ret, ep);
    }

    public static byte[] loadAllFromInputStream(InputStream is) throws IOException {
        int ep = 0;
        int read = 0;
        byte[] ret = new byte[4096];
        while ((read = is.read(ret, ep, ret.length - ep)) > 0) {
            if (ep + read == ret.length) {
                ret = Arrays.copyOf(ret, ret.length * 2);
            }
            ep += read;
        }
        return Arrays.copyOf(ret, ep);
    }

    public static byte[] loadAllFromInputStream(InputStream is, int startBuffer) throws IOException {
        int ep = 0;
        int read = 0;
        byte[] ret = new byte[startBuffer];
        while ((read = is.read(ret, ep, ret.length - ep)) > 0) {
            if (ep + read == ret.length) {
                ret = Arrays.copyOf(ret, ret.length * 2);
            }
            ep += read;
        }
        return Arrays.copyOf(ret, ep);
    }

    public static int copyStream(InputStream is, OutputStream os) throws IOException {
        int w = 0;
        byte[] buff = new byte[4096];
        int cr = 0;
        while ((cr = is.read(buff)) > -1) {
            os.write(buff, 0, cr);
            w += cr;
        }
        return w;
    }

    public static int copyStream(InputStream is, OutputStream os, byte[] buff) throws IOException {
        int w = 0;
        int cr = 0;
        while ((cr = is.read(buff)) > -1) {
            os.write(buff, 0, cr);
            w += cr;
        }
        return w;
    }

    public static int copyStream(InputStream is, OutputStream os, byte[] buff, int limit) throws IOException {
        int w = 0;
        int cr = 0;
        while ((cr = is.read(buff)) > -1) {
            os.write(buff, 0, cr);
            if ((w += cr) < limit) continue;
            return -w;
        }
        return w;
    }

    public static void silentClose(OutputStream outputStream) {
        try {
            outputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void silentClose(InputStream is) {
        try {
            is.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void silentClose(Closeable is) {
        try {
            is.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void silentClose(AutoCloseable is) {
        try {
            is.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static int writeInputStreamToFile(InputStream is, String file) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            int n = IOTools.copyStream(is, fos);
            fos.flush();
            int n2 = n;
            return n2;
        }
    }

    public static int writeStringToFile(String str, String file) throws IOException {
        byte[] d = str.getBytes();
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(d);
            fos.flush();
        }
        return d.length;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getFilePart(String file, long off, int len) throws IOException {
        byte[] ret = null;
        try (FileInputStream fis = new FileInputStream(file);){
            long buf;
            for (long skip = fis.skip(off); skip != off; skip += buf) {
                buf = fis.skip(skip - off);
                if (buf >= 1L) continue;
                fis.close();
                byte[] byArray = new byte[]{};
                return byArray;
            }
            int s = 0;
            ret = new byte[len];
            while (s != len) {
                int read = fis.read(ret, s, len - s);
                if (read == -1) {
                    ret = Arrays.copyOf(ret, s);
                    return ret;
                }
                s += read;
            }
            return ret;
        }
    }

    public static byte[] md5(String content) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(content.getBytes());
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            Mirror.propagateAnyway(e);
            return null;
        }
    }

    protected static byte[] digestWith(MessageDigest md, String file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] data = new byte[4096];
            int read = 0;
            while (-1 < (read = ((InputStream)fis).read(data))) {
                if (0 == read) continue;
                if (data.length == read) {
                    md.update(data);
                    continue;
                }
                md.update(Arrays.copyOf(data, read));
            }
        }
        return md.digest();
    }

    public static byte[] fileChksumMd5(String file) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        return IOTools.digestWith(md, file);
    }

    public static byte[] fileChksumCrc32(String file) throws NoSuchAlgorithmException, IOException {
        CRC32 crc32 = new CRC32();
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] data = new byte[4096];
            int read = 0;
            while (-1 < (read = ((InputStream)fis).read(data))) {
                if (0 == read) continue;
                if (data.length == read) {
                    crc32.update(data);
                    continue;
                }
                crc32.update(Arrays.copyOf(data, read));
            }
        }
        long val = crc32.getValue();
        return new byte[]{(byte)(val >> 24 & 0xFFL), (byte)(val >> 16 & 0xFFL), (byte)(val >> 8 & 0xFFL), (byte)(val & 0xFFL)};
    }

    public static byte[] fileChksumSha256(String file) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        return IOTools.digestWith(md, file);
    }

    public static void loadFillAllLine(String file, Collection<String> lines) throws FileNotFoundException, IOException {
        IOTools.loadFillAllLine(FileSystemTools.DEFAULT_FILESYSTEM.fromUri(file), lines);
    }

    public static void loadFillAllLine(AbstractFile file, Collection<String> lines) throws FileNotFoundException, IOException {
        try (InputStream fis = file.openRead();
             BufferedReader br = new BufferedReader(new InputStreamReader(fis));){
            String line = null;
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static String[] readAllLine(File in) throws FileNotFoundException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static int linesInFile(File f) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void silentFlush(Flushable f) {
        try {
            f.flush();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void processStreamLines(InputStream is, SimplePublish1<String> onReadLine) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(is);
             BufferedReader br = new BufferedReader(isr);){
            String line = null;
            while ((line = br.readLine()) != null) {
                onReadLine.publish(line);
            }
        }
    }

    public static void processFileLines(String file, SimplePublish1<String> onReadLine) throws FileNotFoundException, IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            IOTools.processStreamLines(fis, onReadLine);
        }
    }

    public static String getFileContents(String string) throws FileNotFoundException, IOException {
        try (FileInputStream fis = new FileInputStream(string);){
            String string2 = new String(IOTools.loadAllFromInputStream(fis));
            return string2;
        }
    }

    public static String getFileContents(File string) throws FileNotFoundException, IOException {
        try (FileInputStream fis = new FileInputStream(string);){
            String string2 = new String(IOTools.loadAllFromInputStream(fis));
            return string2;
        }
    }

    public static String getFileContents(AbstractFile file) throws FileNotFoundException, IOException {
        try (InputStream fis = file.openRead();){
            String string = new String(IOTools.loadAllFromInputStream(fis));
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getURL(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        InputStream is = conn.getInputStream();
        try {
            byte[] byArray = IOTools.loadAllFromInputStream(conn.getInputStream());
            return byArray;
        }
        finally {
            IOTools.silentClose(is);
        }
    }

    public static void feedAllLine(String file, SimplePublish1<String> feed) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);
             InputStreamReader isr = new InputStreamReader(fis);
             BufferedReader br = new BufferedReader(isr);){
            String line = null;
            while (null != (line = br.readLine())) {
                feed.publish(line);
            }
        }
    }

    public static SimpleCall readAllStdInLine(final SimplePublish1<String> feed) {
        return new SimpleCall(){

            @Override
            public void call() {
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                    String line = null;
                    while (null != (line = br.readLine())) {
                        feed.publish(line);
                    }
                }
                catch (Exception e) {
                    Mirror.propagateAnyway(e);
                }
            }
        };
    }

    public static String[] readAllLine(String string) throws FileNotFoundException, IOException {
        return IOTools.readAllLine(new File(string));
    }

    public static void createPathBeforeFile(File file) {
        IOTools.createPathBeforeFile(file.toString());
    }

    public static void createPathBeforeFile(String file) {
        if (file.endsWith("/")) {
            new File(file).mkdirs();
        } else {
            String path = StringTools.getSubstringBeforeLastString(file, "/", null);
            if (null != path) {
                new File(path).mkdirs();
            }
        }
    }

    public static String readLine_rn(InputStream is, byte[] buffer, int max) throws IOException {
        if (is.markSupported()) {
            return IOTools.readLine_rn_withMarkSupport(is, buffer, max);
        }
        int ep = 0;
        for (int i = 0; i < max; ++i) {
            int read = is.read();
            if (0 > read) {
                if (0 != i) break;
                return null;
            }
            if (13 == read) continue;
            if (10 == read) break;
            buffer[ep++] = (byte)read;
        }
        return new String(buffer, 0, ep);
    }

    protected static String readLine_rn_withMarkSupport(InputStream is, byte[] buffer, int max) throws IOException {
        is.mark(max);
        int size = is.read(buffer);
        int index = -1;
        for (int i = 0; i < size; ++i) {
            if (10 != buffer[i]) continue;
            index = i;
            break;
        }
        if (-1 == index) {
            is.reset();
            return null;
        }
        if (0 == index) {
            return "";
        }
        is.reset();
        is.skip(index + 1);
        return new String(buffer, 0, index - 1);
    }

    public static void appendData(String file, byte[] data) throws IOException {
        try (FileOutputStream os = new FileOutputStream(file, true);){
            ((OutputStream)os).write(data);
            os.flush();
        }
    }

    public static void copyFileContentToStream(File f, OutputStream os) throws FileNotFoundException, IOException {
        try (FileInputStream is = new FileInputStream(f);){
            IOTools.copyStream(is, os);
        }
    }

    public static int indexOfBytes(byte[] source, int sourceOffset, int sourceCount, byte[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        byte first = target[targetOffset];
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    public static int indexOfBytes(byte[] source, byte[] target, int fromIndex, int endindex) {
        return IOTools.indexOfBytes(source, 0, endindex, target, 0, target.length, fromIndex);
    }

    public static int readFull(InputStream is, byte[] data) throws IOException {
        int off;
        int read = 0;
        for (off = 0; off < data.length && (read = is.read(data, off, data.length - off)) > -1; off += read) {
        }
        return off;
    }

    public static String tryGetContent(AbstractFile file, String _default) {
        try {
            return IOTools.getFileContents(file);
        }
        catch (Exception e) {
            return _default;
        }
    }

    public static void ungzip(File from, File to) throws FileNotFoundException, IOException {
        try (FileInputStream is = new FileInputStream(from);
             GZIPInputStream gin = new GZIPInputStream(is);
             FileOutputStream os = new FileOutputStream(to);){
            IOTools.copyStream(gin, os);
            os.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeOnExit(Closeable close) {
        if (null == close) {
            return;
        }
        Set<Closeable> set = IoToolsShutdownAutoClose.CLOSE_ON_EXIT;
        synchronized (set) {
            IoToolsShutdownAutoClose.CLOSE_ON_EXIT.add(close);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void revokeCloseOnExit(Closeable close) {
        if (null == close) {
            return;
        }
        Set<Closeable> set = IoToolsShutdownAutoClose.CLOSE_ON_EXIT;
        synchronized (set) {
            IoToolsShutdownAutoClose.CLOSE_ON_EXIT.remove(close);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCloseOnExit(Closeable close) {
        if (null == close) {
            return false;
        }
        Set<Closeable> set = IoToolsShutdownAutoClose.CLOSE_ON_EXIT;
        synchronized (set) {
            return IoToolsShutdownAutoClose.CLOSE_ON_EXIT.contains(close);
        }
    }

    protected static final class IoToolsShutdownAutoClose {
        protected static Set<Closeable> CLOSE_ON_EXIT = new HashSet<Closeable>();

        protected IoToolsShutdownAutoClose() {
        }

        static {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Closeable[] closeableArray = CLOSE_ON_EXIT;
                    synchronized (CLOSE_ON_EXIT) {
                        Closeable[] close = CLOSE_ON_EXIT.toArray(new Closeable[0]);
                        // ** MonitorExit[var2_1] (shouldn't be in output)
                        for (Closeable c : close) {
                            IOTools.silentClose(c);
                        }
                        return;
                    }
                }
            });
        }
    }
}

