/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.io;

import eu.javaexperience.reflect.Mirror;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Formatter;
import java.util.Locale;

public class LocklessPrintWriter
extends PrintWriter {
    protected Formatter formatter = null;
    protected boolean autoFlush;
    protected static String DEFAULT_LINE_SEPARATOR = "\n";
    protected String lineSeparator = DEFAULT_LINE_SEPARATOR;
    private char[] buf = new char[1];

    public LocklessPrintWriter(OutputStream os, boolean autoFlush) {
        super(os, autoFlush);
    }

    public LocklessPrintWriter(OutputStream os) {
        super(os);
    }

    @Override
    public void write(int c) {
        this.buf[0] = (char)c;
        this.write(this.buf, 0, 1);
    }

    @Override
    public void write(char[] cbuf) {
        this.write(cbuf, 0, cbuf.length);
    }

    @Override
    public void write(String str) {
        this.write(str, 0, str.length());
    }

    @Override
    public void write(String str, int off, int len) {
        if (len > this.buf.length) {
            this.buf = new char[len];
        }
        str.getChars(off, off + len, this.buf, 0);
        this.write(this.buf, 0, len);
    }

    @Override
    public PrintWriter append(CharSequence csq) {
        if (csq == null) {
            this.write("null");
        } else {
            this.write(csq.toString());
        }
        return this;
    }

    @Override
    public PrintWriter append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        this.write(cs.subSequence(start, end).toString());
        return this;
    }

    @Override
    public PrintWriter append(char c) {
        this.write(c);
        return this;
    }

    private void newLine() {
        this.write(this.lineSeparator);
        if (this.autoFlush) {
            this.flush();
        }
    }

    @Override
    public void print(boolean b) {
        this.write(b ? "true" : "false");
    }

    @Override
    public void print(char c) {
        this.write(c);
    }

    @Override
    public void print(int i) {
        this.write(String.valueOf(i));
    }

    @Override
    public void print(long l) {
        this.write(String.valueOf(l));
    }

    @Override
    public void print(float f) {
        this.write(String.valueOf(f));
    }

    @Override
    public void print(double d) {
        this.write(String.valueOf(d));
    }

    @Override
    public void print(char[] s) {
        this.write(s);
    }

    @Override
    public void print(String s) {
        if (s == null) {
            s = "null";
        }
        this.write(s);
    }

    @Override
    public void print(Object obj) {
        this.write(String.valueOf(obj));
    }

    @Override
    public void println() {
        this.newLine();
    }

    @Override
    public void println(boolean x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(char x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(int x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(long x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(float x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(double x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(char[] x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(String x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(Object x) {
        this.print(String.valueOf(x));
        this.println();
    }

    @Override
    public PrintWriter printf(String format, Object ... args) {
        return this.format(format, args);
    }

    @Override
    public void write(char[] buf, int off, int len) {
        try {
            this.out.write(buf, off, len);
        }
        catch (Exception e) {
            Mirror.propagateAnyway(e);
        }
    }

    @Override
    public PrintWriter printf(Locale l, String format, Object ... args) {
        return this.format(l, format, args);
    }

    @Override
    public PrintWriter format(String format, Object ... args) {
        if (this.formatter == null) {
            this.formatter = new Formatter(this);
        }
        this.formatter.format(Locale.getDefault(), format, args);
        if (this.autoFlush) {
            this.flush();
        }
        return this;
    }

    @Override
    public PrintWriter format(Locale l, String format, Object ... args) {
        if (this.formatter == null) {
            this.formatter = new Formatter(this);
        }
        this.formatter.format(l, format, args);
        if (this.autoFlush) {
            this.flush();
        }
        return this;
    }

    static {
        try {
            DEFAULT_LINE_SEPARATOR = String.format("%n", new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

