/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.io;

import java.io.IOException;
import java.io.Writer;

public abstract class LocklessWriter
extends Writer {
    private char[] buf = new char[1];

    @Override
    public void write(int c) throws IOException {
        this.buf[0] = (char)c;
        this.write(this.buf, 0, 1);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.write(cbuf, 0, cbuf.length);
    }

    @Override
    public void write(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (len > this.buf.length) {
            this.buf = new char[len];
        }
        str.getChars(off, off + len, this.buf, 0);
        this.write(this.buf, 0, len);
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        if (csq == null) {
            this.write("null");
        } else {
            this.write(csq.toString());
        }
        return this;
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        CharSequence cs = csq == null ? "null" : csq;
        this.write(cs.subSequence(start, end).toString());
        return this;
    }

    @Override
    public Writer append(char c) throws IOException {
        this.write(c);
        return this;
    }

    @Override
    public abstract void write(char[] var1, int var2, int var3) throws IOException;

    @Override
    public abstract void flush() throws IOException;

    @Override
    public abstract void close() throws IOException;
}

