/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.io;

public abstract class Utf8Encoder {
    protected byte[] buf;
    protected int ep = -1;

    public Utf8Encoder(int size) {
        this.buf = new byte[size];
    }

    public Utf8Encoder(byte[] buffer) {
        this.buf = buffer;
    }

    public void encode(char[] sa, int sp, int len) {
        int end = sp + len;
        for (int i = sp; i < end; ++i) {
            char c;
            if (this.ep + 4 >= this.buf.length) {
                this.flushBuffer();
            }
            if ((c = sa[i]) < '\u0080') {
                this.buf[++this.ep] = (byte)c;
                continue;
            }
            if (c <= '\u07ff') {
                this.buf[++this.ep] = (byte)((c >> 6) + 192);
                this.buf[++this.ep] = (byte)((c & 0x3F) + 128);
                continue;
            }
            if (c <= '\uffff') {
                this.buf[++this.ep] = (byte)((c >> 12) + 224);
                this.buf[++this.ep] = (byte)((c >> 6 & 0x3F) + 128);
                this.buf[++this.ep] = (byte)((c & 0x3F) + 128);
                continue;
            }
            if (c > '\u10ffff') continue;
            this.buf[++this.ep] = (byte)((c >> 18) + 240);
            this.buf[++this.ep] = (byte)((c >> 12 & 0x3F) + 128);
            this.buf[++this.ep] = (byte)((c >> 6 & 0x3F) + 128);
            this.buf[++this.ep] = (byte)((c & 0x3F) + 128);
        }
    }

    protected void flushBuffer() {
        if (this.ep > 0) {
            this.putOutput(this.buf, 0, this.ep + 1);
            this.ep = -1;
        }
    }

    protected abstract void putOutput(byte[] var1, int var2, int var3);
}

