/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.io.file;

import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish2;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.regex.RegexTools;
import eu.javaexperience.text.Format;
import eu.javaexperience.text.StringTools;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;

public class FileTools {
    public static long _1Kb = 1024L;
    public static long _1Mb = _1Kb * 1024L;
    public static long _1Gb = _1Mb * 1024L;
    public static long _1Tb = _1Gb * 1024L;
    public static final File[] emptyFileArray = new File[0];

    public static void find(File root, Collection<File> res) {
        FileTools.find(root, (File e) -> res.add((File)e));
    }

    public static void find(File root, SimplePublish1<File> res) {
        res.publish(root);
        if (root.isDirectory()) {
            for (File f : root.listFiles()) {
                FileTools.find(f, res);
            }
        }
    }

    public static void conditionalFindDirs(File root, GetBy1<Boolean, File> cond) {
        if (root.isDirectory() && Boolean.TRUE == cond.getBy(root)) {
            for (File f : root.listFiles()) {
                FileTools.conditionalFindDirs(f, cond);
            }
        }
    }

    public static void deleteDirectory(File file, boolean follow_symlinks) {
        if (!file.exists()) {
            return;
        }
        if (!follow_symlinks && Files.isSymbolicLink(file.toPath())) {
            return;
        }
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                FileTools.deleteDirectory(f, follow_symlinks);
            }
        }
        file.delete();
    }

    public static String toBytesKbMbGbOrTb(long size) {
        if (size >= _1Tb) {
            return Format.cutFloatDecimals(String.valueOf((double)size / (double)_1Tb), 3) + " Tb";
        }
        if (size >= _1Gb) {
            return Format.cutFloatDecimals(String.valueOf((double)size / (double)_1Gb), 3) + " Gb";
        }
        if (size >= _1Mb) {
            return Format.cutFloatDecimals(String.valueOf((double)size / (double)_1Mb), 3) + " Mb";
        }
        if (size >= _1Kb) {
            return Format.cutFloatDecimals(String.valueOf((double)size / (double)_1Kb), 3) + " Kb";
        }
        return size + " b";
    }

    public static File generateTempFilename(String prefix, int i, String postfix) throws IOException {
        File f;
        while ((f = new File(prefix + StringTools.randomString(i) + postfix)).exists()) {
        }
        return f;
    }

    public static File getExisting(File ... files) {
        for (File f : files) {
            if (!f.exists()) continue;
            return f;
        }
        return null;
    }

    public static void move(File from, File to) {
        try {
            Files.move(from.toPath(), to.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            Mirror.throwSoftOrHardButAnyway(e);
        }
    }

    public static void copy(File from, File to) {
        try {
            Files.copy(from.toPath(), to.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            Mirror.throwSoftOrHardButAnyway(e);
        }
    }

    public static void createDirectoryIfNotExtists(String dir) {
        File f = new File(dir);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public static String canonicalFilename(String localWD) {
        try {
            return new File(localWD).getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static File tryGetCanonicalFile(String f) {
        return FileTools.tryGetCanonicalFile(new File(f));
    }

    public static File tryGetCanonicalFile(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void globFiles(Collection<File> files, File start, boolean relativeGlob, String glob) throws IOException {
        Path startingDir = start.toPath();
        Finder finder = new Finder(glob);
        finder.setResultCollection(files);
        if (relativeGlob) {
            String str = start.toString();
            if (start.isDirectory()) {
                str = StringTools.ensureEndsWith(str, "/");
            }
            finder.setcutPrefix(str);
        }
        Files.walkFileTree(startingDir, finder);
    }

    public static File getDirectory(File f) {
        if (f.isDirectory()) {
            throw new RuntimeException(f + " is already a directory");
        }
        return new File(StringTools.getSubstringBeforeLastString(f.toString(), "/", "/"));
    }

    public static void translateFiles(boolean recursive, File fromDir, File toDir, SimplePublish2<File, File> operation) {
        if (!fromDir.isDirectory()) {
            throw new RuntimeException("Source file is not directory: " + fromDir);
        }
        if (!toDir.exists()) {
            toDir.mkdirs();
        }
        if (!toDir.isDirectory()) {
            throw new RuntimeException("Destination file is not directory: " + toDir);
        }
        String toDirString = toDir.toString();
        for (File f : fromDir.listFiles()) {
            String last = StringTools.getSubstringAfterLastString(f.toString(), "/");
            File to = new File(toDirString + "/" + last);
            if (f.isDirectory()) {
                if (!recursive) continue;
                FileTools.translateFiles(recursive, f, to, operation);
                continue;
            }
            operation.publish(f, to);
        }
    }

    public static void slientDelete(File f) {
        try {
            f.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String normalizeSlashes(String file) {
        return RegexTools.SLASHES_LINUX_WINDOWS.matcher(file).replaceAll("/");
    }

    public static boolean createDirectoryForFile(File f) {
        File dir = FileTools.getDirectory(f);
        return dir.mkdirs();
    }

    public static class Finder
    extends SimpleFileVisitor<Path> {
        protected final PathMatcher matcher;
        protected String cutPathPrefix;
        protected Collection<File> dst;

        public void setcutPrefix(String pref) {
            this.cutPathPrefix = pref;
        }

        Finder(String pattern) {
            this.matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
        }

        void find(Path origin) {
            Path set;
            String str;
            Path file = origin;
            if (null != this.cutPathPrefix && null != (str = StringTools.getSubstringAfterFirstString(file.toString(), this.cutPathPrefix, null)) && null != (set = new File(str).toPath())) {
                file = set;
            }
            if (file != null && this.matcher.matches(file) && null != this.dst) {
                this.dst.add(origin.toFile());
            }
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            this.find(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            this.find(dir);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            System.err.println(exc);
            return FileVisitResult.CONTINUE;
        }

        public Collection<File> getResultCollection() {
            return this.dst;
        }

        public void setResultCollection(Collection<File> dst) {
            this.dst = dst;
        }
    }
}

