/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.io.modification;

import eu.javaexperience.exceptions.UnimplementedCaseException;
import eu.javaexperience.interfaces.simple.publish.SimplePublish2;
import eu.javaexperience.io.modification.FileEvent;
import eu.javaexperience.multithread.Job;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;

public class DirectoryWatchJob
implements Job<Void> {
    private final WatchService ws = FileSystems.getDefault().newWatchService();
    private final Path p;
    private final SimplePublish2<Path, FileEvent> publish;

    public DirectoryWatchJob(File dir, SimplePublish2<Path, FileEvent> onFileChange) throws IOException {
        this.p = dir.toPath();
        this.publish = onFileChange;
    }

    public static FileEvent asEvent(WatchEvent.Kind<Path> ev) {
        if (ev == StandardWatchEventKinds.ENTRY_CREATE) {
            return FileEvent.created;
        }
        if (ev == StandardWatchEventKinds.ENTRY_DELETE) {
            return FileEvent.deleted;
        }
        if (ev == StandardWatchEventKinds.ENTRY_MODIFY) {
            return FileEvent.modified;
        }
        throw new UnimplementedCaseException("no case defined for " + ev);
    }

    @Override
    public void exec(Void param) throws Throwable {
        try {
            this.p.register(this.ws, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            while (true) {
                WatchKey cwk = this.ws.take();
                for (WatchEvent<?> event : cwk.pollEvents()) {
                    this.publish.publish((Path)event.context(), DirectoryWatchJob.asEvent(event.kind()));
                }
                cwk.reset();
            }
        }
        catch (Throwable throwable) {
            this.ws.close();
            throw throwable;
        }
    }
}

