/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.io.storage;

import eu.javaexperience.io.FileContentMapper;
import eu.javaexperience.text.StringTools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class StoragesWarehouse<S extends Serializable> {
    protected String rootDir;
    protected Map<String, FileContentMapper<S>> pageStorages = new HashMap<String, FileContentMapper<S>>();

    public StoragesWarehouse(String dir) {
        this.rootDir = dir;
        new File(dir).mkdirs();
    }

    public synchronized FileContentMapper<S> getStorage(String name) throws FileNotFoundException {
        FileContentMapper<Object> ret = this.pageStorages.get(name);
        if (null == ret) {
            File dir = new File(this.rootDir + "/" + name);
            dir.mkdirs();
            ret = new FileContentMapper(dir);
            this.pageStorages.put(name, ret);
        }
        return ret;
    }

    public static void main(String[] args) throws Throwable {
        StoragesWarehouse env = new StoragesWarehouse("/tmp/spider_test");
        FileContentMapper store = env.getStorage("teszt_bin");
        store.put("0", (Object)"\u00c1rv\u00edzt\u0171r\u0151 t\u00fck\u00f6rf\u00far\u00f3g\u00e9p".getBytes());
        store.put("1", (Object)StringTools.repeatString("\u00c1rv\u00edzt\u0171r\u0151 t\u00fck\u00f6rf\u00far\u00f3g\u00e9p", 100).getBytes());
        store = env.getStorage("teszt_txt");
        store.put("0", (Object)"\u00c1rv\u00edzt\u0171r\u0151 t\u00fck\u00f6rf\u00far\u00f3g\u00e9p");
        store.put("1", (Object)StringTools.repeatString("\u00c1rv\u00edzt\u0171r\u0151 t\u00fck\u00f6rf\u00far\u00f3g\u00e9p", 100));
    }
}

