/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.log;

import eu.javaexperience.io.IOTools;
import eu.javaexperience.log.LogOutput;
import eu.javaexperience.resource.ReferenceCounted;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.PrintWriter;

public abstract class RotaLogOutput
implements LogOutput {
    protected ReferenceCounted<PrintWriter> currentLogOutput = null;

    protected abstract File getNextLogfile();

    protected abstract boolean needCut();

    protected void afterOpenNewUnit() {
    }

    protected ReferenceCounted<PrintWriter> openNextLogUnit() throws IOException {
        File f = this.getNextLogfile();
        PrintWriter ret = null;
        ret = f.exists() ? new PrintWriter(new FileOutputStream(f, true), true) : new PrintWriter(f);
        return new ReferenceCounted<PrintWriter>(ret, 1){

            @Override
            protected void onFree() {
                IOTools.silentFlush((Flushable)this.subject);
                IOTools.silentClose((Closeable)this.subject);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReferenceCounted<PrintWriter> getLogOutput() throws IOException {
        RotaLogOutput rotaLogOutput = this;
        synchronized (rotaLogOutput) {
            if (null == this.currentLogOutput) {
                this.currentLogOutput = this.openNextLogUnit();
                this.afterOpenNewUnit();
            } else if (this.needCut()) {
                this.currentLogOutput.release();
                this.currentLogOutput = this.openNextLogUnit();
                this.afterOpenNewUnit();
            }
            this.currentLogOutput.acquire();
            return this.currentLogOutput;
        }
    }
}

