/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.measurement;

import eu.javaexperience.measurement.AvgStdDev;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class MeasurementSerie
implements Iterable<MeasurementData> {
    private boolean calcualted = false;
    ArrayList<MeasurementData> x = new ArrayList();
    protected double _x;
    protected double s;
    protected double E;
    protected MeasurementData max;
    protected MeasurementData min;
    public static final double PI = Math.PI;
    public static final double PI_per_2 = 1.5707963267948966;
    public static final double PI_per_2_delta_15_percent = 0.23561944901923448;
    public static final double Gauss_min = 1.335176877775662;
    public static final double Gauss_max = 1.806415775814131;

    public void add(double num) {
        this.x.add(new MeasurementData(num));
        this.calcualted = false;
    }

    public void add(double ... num) {
        for (double d : num) {
            this.add(d);
        }
    }

    public boolean isGaussDeviance() {
        double approx = this.getAbsoluteGauss();
        return approx > 1.335176877775662 && approx < 1.806415775814131;
    }

    public double getAbsoluteGauss() {
        this.assureCalcualted();
        if (0.0 == this.s) {
            return 0.0;
        }
        return this.s * this.s / (this.E * this.E);
    }

    public double getRelativeGaussApproximation() {
        return 100.0 * (this.getAbsoluteGauss() - 1.5707963267948966) / 1.5707963267948966;
    }

    public double getAverage() {
        this.assureCalcualted();
        return this._x;
    }

    public double getStandardDeviance() {
        this.assureCalcualted();
        return this.s;
    }

    private void assureCalcualted() {
        if (!this.calcualted && !this.calculate()) {
            throw new IllegalStateException("A m\u00e9r\u00e9si sorozatnak legal\u00e1bb egy eredm\u00e9nyt kell tartalmaznia");
        }
    }

    public MeasurementData k\u00e9rMaximum() {
        return this.max;
    }

    public MeasurementData k\u00e9rMinimum() {
        return this.min;
    }

    public double getAverageAbsoluteDeviance() {
        this.assureCalcualted();
        return this.E;
    }

    public void dropUpperAndLowerPercent(double d) {
        Collections.sort(this.x);
        int num = (int)((double)this.x.size() * d);
        for (int i = 0; i < num; ++i) {
            this.x.remove(0);
            this.x.remove(this.x.size() - 1);
        }
        this.calcualted = false;
    }

    public void dropUpperAndLower5Percent() {
        this.dropUpperAndLowerPercent(0.05);
    }

    public boolean calculate() {
        double sum = 0.0;
        if (this.x.size() == 0) {
            return false;
        }
        for (MeasurementData ad : this.x) {
            sum += ad.value;
        }
        double darab = this.x.size();
        this._x = sum / darab;
        double sumDeltaSquare = 0.0;
        double absDeltaSum = 0.0;
        this.min = this.max = this.x.get(0);
        for (MeasurementData adat : this.x) {
            if (this.min.value > adat.value) {
                this.min = adat;
            }
            if (this.max.value < adat.value) {
                this.max = adat;
            }
            adat.delta = adat.value - this._x;
            absDeltaSum += Math.abs(adat.delta);
            sumDeltaSquare += Math.pow(adat.delta, 2.0);
        }
        this.s = this.x.size() > 1 ? Math.sqrt(sumDeltaSquare * (1.0 / ((double)this.x.size() - 1.0))) : 0.0;
        this.E = absDeltaSum / darab;
        this.calcualted = true;
        return true;
    }

    public double getPositiveAbsoluteDeviance() {
        return this.max.value - this._x;
    }

    public double getNegativeAbsoluteDeviance() {
        return this.min.value - this._x;
    }

    public void printTable(PrintStream ps) {
        this.assureCalcualted();
        ps.println("|n\t|value\t|delta\t|delta^2|");
        int i = 0;
        for (MeasurementData a : this) {
            ps.printf("|%d\t|%s\t|%s\t|%s\t|\n", ++i, this.formatNumber(a.value), this.formatNumber(a.delta), this.formatNumber(Math.pow(a.delta, 2.0)));
        }
    }

    public String getPrintedSummarise() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        try {
            this.printSummarize(ps);
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return new String(baos.toByteArray());
    }

    public AvgStdDev getAvgAndStdDev() {
        return new AvgStdDev(this.getAverage(), this.getStandardDeviance());
    }

    public void printSummarize(PrintStream ps) {
        this.assureCalcualted();
        ps.println("=== M\u00e9r\u00e9si eredm\u00e9ny \u00f6sszes\u00edt\u00e9s ===\n");
        ps.print("Elemsz\u00e1m [n]: ");
        ps.println(this.x.size());
        ps.print("Legnagyobb elem: ");
        ps.println(this.formatNumber(this.k\u00e9rMaximum().value));
        ps.print("Legkisebb elem: ");
        ps.println(this.formatNumber(this.k\u00e9rMinimum().value));
        ps.print("Pozit\u00edv Abszol\u00fat terjedelem: ");
        ps.println(this.formatNumber(this.getPositiveAbsoluteDeviance()));
        ps.print("Negat\u00edv Abszol\u00fat terjedelem: ");
        ps.println(this.formatNumber(this.getNegativeAbsoluteDeviance()));
        ps.print("\u00c1tlag [_x]: ");
        ps.println(this.formatNumber(this.getAverage()));
        ps.print("Pozit\u00edv Relat\u00edv terjedelem: ");
        ps.println(this.formatNumber(this.getPositiveAbsoluteDeviance()));
        ps.print("Negat\u00edv Relat\u00edv terjedelem: ");
        ps.println(this.formatNumber(this.getNegativeAbsoluteDeviance()));
        ps.print("Sz\u00f3r\u00e1s [s]:");
        ps.println(this.formatNumber(this.getStandardDeviance()));
        ps.print("\u00c1ltagos abszol\u00fat elt\u00e9r\u00e9s [E]: ");
        ps.println(this.formatNumber(this.getAverageAbsoluteDeviance()));
        ps.print("Abszol\u00fat Gauss k\u00f6zel\u00edt\u00e9si \u00e9rt\u00e9k [s^2/E^2]: ");
        ps.println(this.formatNumber(this.getAbsoluteGauss()));
        ps.print("Relat\u00edv Gauss k\u00f6zel\u00edt\u00e9si \u00e9rt\u00e9k:");
        ps.println(this.formatNumber(this.getRelativeGaussApproximation()));
        ps.print("Gauss eloszl\u00e1s\u00fa [s^2/E^2 ~ pi/2 +- 15%]: ");
        ps.println(this.isGaussDeviance() ? "Igen" : "Nem");
    }

    public String formatNumber(double num) {
        StringBuilder sb = new StringBuilder();
        sb.append(num);
        int i = sb.indexOf(".");
        if (i > 0 && i + 3 < sb.length()) {
            sb.delete(i + 4, sb.length());
        }
        return sb.toString();
    }

    public String getShortStat() {
        this.calculate();
        StringBuilder sb = new StringBuilder();
        sb.append("Measurement report from ");
        sb.append(this.x.size());
        sb.append(" samples: avg:");
        sb.append(this.formatNumber(this.getAverage()));
        sb.append(", dev: \u00b1");
        sb.append(this.formatNumber(this.getStandardDeviance()));
        sb.append(", g: ");
        sb.append(this.formatNumber(this.getAbsoluteGauss()));
        sb.append(" (");
        sb.append(this.formatNumber(this.getRelativeGaussApproximation()));
        sb.append(" %)");
        return sb.toString();
    }

    public static void main(String[] args) throws Throwable {
        MeasurementSerie sor = new MeasurementSerie();
        sor.add(100.2, 100.0, 100.4, 100.15, 100.25, 100.17, 100.22, 100.2);
        sor.calculate();
        sor.printSummarize(System.out);
        sor.printTable(System.out);
    }

    public MeasurementSerie clone() {
        MeasurementSerie sor = new MeasurementSerie();
        for (MeasurementData ad : this) {
            sor.add(ad.value);
        }
        return sor;
    }

    @Override
    public Iterator<MeasurementData> iterator() {
        return this.x.iterator();
    }

    public double getMaximumValue() {
        this.assureCalcualted();
        return this.max.value;
    }

    public double getMinimumValue() {
        this.assureCalcualted();
        return this.min.value;
    }

    public int elementsCount() {
        return this.x.size();
    }

    public static class MeasurementData
    implements Comparable<MeasurementData>,
    Cloneable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private double value;
        private double delta;

        public MeasurementData(double value) {
            this.value = value;
        }

        public double getValue() {
            return this.value;
        }

        public double getAbsoluteDeviance() {
            return this.delta;
        }

        public Object clone() {
            return new MeasurementData(this.value);
        }

        @Override
        public int compareTo(MeasurementData arg0) {
            return Double.compare(this.value, arg0.value);
        }
    }
}

