/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.multithread;

import eu.javaexperience.interfaces.simple.publish.SimplePublish2;
import eu.javaexperience.multithread.MultithreadingTools;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class RerunnableThread<T> {
    protected final Semaphore accept = new Semaphore(0);
    protected final Semaphore free = new Semaphore(0);
    protected volatile T param = null;
    protected volatile long lastUsed = 0L;
    private final Thread worker = new Thread(){

        @Override
        public void run() {
            while (true) {
                try {
                    RerunnableThread.this.free.release();
                    RerunnableThread.this.accept.acquire();
                }
                catch (InterruptedException e) {
                    return;
                }
                try {
                    RerunnableThread.this.runThis(RerunnableThread.this.param);
                }
                catch (Throwable e) {
                    if (e == POISON) {
                        return;
                    }
                    System.err.println("TOPLEVEL UNCATCHED EXCEPTION");
                    e.printStackTrace();
                    try {
                        if (RerunnableThread.this.onException != null) {
                            RerunnableThread.this.onException.publish(RerunnableThread.this, e);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                RerunnableThread.this.param = null;
            }
        }
    };
    public static final Error POISON = MultithreadingTools.THREAD_SHUTDOWN_POISON;
    protected SimplePublish2<RerunnableThread<T>, Throwable> onException = null;

    public RerunnableThread(boolean daemon) {
        this.worker.setDaemon(daemon);
        this.worker.start();
    }

    public RerunnableThread() {
        this(false);
    }

    public StackTraceElement[] getStackTraceElements() {
        return this.worker.getStackTrace();
    }

    protected void stopCallerThread() {
        throw POISON;
    }

    public boolean isDaemon() {
        return this.worker.isDaemon();
    }

    public void waitFree(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (this.free.tryAcquire(timeout, unit)) {
            this.free.release();
            return;
        }
        throw new TimeoutException();
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    public boolean tryRerun(T param) {
        if (this.free.tryAcquire()) {
            this.param = param;
            this.lastUsed = System.currentTimeMillis();
            this.accept.release();
            return true;
        }
        return false;
    }

    public boolean isFree() {
        return 0 != this.free.availablePermits();
    }

    public T getParam() {
        return this.param;
    }

    public abstract void runThis(T var1) throws Throwable;

    public void finalize() {
        this.worker.interrupt();
    }
}

