/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.multithread;

import eu.javaexperience.multithread.RerunnableThread;
import eu.javaexperience.reflect.Mirror;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class TaskExecutorPool
implements Executor {
    protected final Collection<RerunnableThread<Runnable>> execs = new ArrayList<RerunnableThread<Runnable>>();

    protected RerunnableThread<Runnable> executorCreator() {
        RerunnableThread<Runnable> ret = new RerunnableThread<Runnable>(){

            @Override
            public void runThis(Runnable param) throws Throwable {
                param.run();
            }
        };
        try {
            ret.waitFree(1L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            Mirror.propagateAnyway(e);
        }
        return ret;
    }

    @Override
    public synchronized void execute(Runnable exec) {
        for (RerunnableThread<Runnable> e : this.execs) {
            if (!e.tryRerun(exec)) continue;
            return;
        }
        RerunnableThread<Runnable> r = this.executorCreator();
        r.tryRerun(exec);
        this.execs.add(r);
    }

    public synchronized int getThreadsCount() {
        return this.execs.size();
    }
}

