/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.patterns.behavioral.cor.link;

import eu.javaexperience.collection.map.KeyVal;
import eu.javaexperience.dispatch.Dispatcher;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.patterns.behavioral.cor.link.CorChainLink;
import eu.javaexperience.reflect.Mirror;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CorTools {
    public static void main(String[] args) {
        String url;
        Pattern p = Pattern.compile("http://localhost.hu(.*)");
        Matcher m = p.matcher(url = "http://(.*)localhost.hu/page/article");
        if (!m.find()) {
            throw new RuntimeException("Not match");
        }
    }

    public static <CTX> CorChainLink<CTX> wrapCheckerActor(final GetBy1<Boolean, CTX> checker, final SimplePublish1<CTX> actor) {
        return new CorChainLink<CTX>(){

            @Override
            public boolean dispatch(CTX ctx) {
                if (Boolean.TRUE == checker.getBy(ctx)) {
                    actor.publish(ctx);
                    return true;
                }
                return false;
            }
        };
    }

    public static <CTX> CorChainLink<CTX> wrap(final GetBy1<Boolean, CTX> checker, final SimplePublish1<CTX> actor) {
        return new CorChainLink<CTX>(){

            @Override
            public boolean dispatch(CTX ctx) {
                if (Boolean.TRUE == checker.getBy(ctx)) {
                    actor.publish(ctx);
                    return true;
                }
                return false;
            }
        };
    }

    public static <CTX> CorChainLink<CTX> exitChain(final GetBy1<Boolean, CTX> checker) {
        return new CorChainLink<CTX>(){

            @Override
            public boolean dispatch(CTX ctx) {
                if (Boolean.TRUE == checker.getBy(ctx)) {
                    this.ownerChain.exitChain();
                    return true;
                }
                return false;
            }
        };
    }

    public static <CTX> CorChainLink<CTX> jumpChain(final GetBy1<Boolean, CTX> checker, final String chain_name) {
        return new CorChainLink<CTX>(){

            @Override
            public boolean dispatch(CTX ctx) {
                if (Boolean.TRUE == checker.getBy(ctx)) {
                    this.ownerChain.jumpToChain(ctx, chain_name);
                    return true;
                }
                return false;
            }
        };
    }

    public static <CTX> CorChainLink<CTX> includeChain(final GetBy1<Boolean, CTX> checker, final String chain_name) {
        return new CorChainLink<CTX>(){

            @Override
            public boolean dispatch(CTX ctx) {
                if (Boolean.TRUE == checker.getBy(ctx)) {
                    return this.ownerChain.includeChain(ctx, chain_name);
                }
                return false;
            }
        };
    }

    public static KeyVal<String, Dispatcher>[] scanClassStaticMethodsForControllers(Class cls, GetBy1<String, Method> idExaminer, GetBy1<Dispatcher, Method> callWrapper) {
        ArrayList<KeyVal<String, Dispatcher>> ret = new ArrayList<KeyVal<String, Dispatcher>>();
        Mirror.ClassData cd = Mirror.getClassData(cls);
        for (Method m : cd.getAllMethods()) {
            Dispatcher d;
            String id;
            if (!Mirror.isStatic(m) || !Mirror.isPublic(m) || null == (id = idExaminer.getBy(m)) || null == (d = callWrapper.getBy(m))) continue;
            ret.add(new KeyVal<String, Dispatcher>(id, d));
        }
        return ret.toArray(KeyVal.emptyArrayInstance);
    }

    public static <C> GetBy1<Dispatcher<C>, Method> generateWrapperForStatic1ArgTypedFunction(final Class<C> paramAcceptType) {
        return new GetBy1<Dispatcher<C>, Method>(){

            @Override
            public Dispatcher<C> getBy(final Method m) {
                Parameter[] ps;
                if (Mirror.isStatic(m) && Mirror.isPublic(m) && 1 == (ps = m.getParameters()).length && paramAcceptType.isAssignableFrom(ps[0].getType())) {
                    return new Dispatcher<C>(){

                        @Override
                        public boolean dispatch(C ctx) {
                            try {
                                m.invoke(null, ctx);
                            }
                            catch (Exception e) {
                                Mirror.propagateAnyway(e);
                            }
                            return true;
                        }
                    };
                }
                return null;
            }
        };
    }
}

