/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.patterns.creational.builder;

import eu.javaexperience.interfaces.simple.publish.SimplePublish1;

public abstract class PublisherBuilder<P, R, I>
implements SimplePublish1<P> {
    protected R result;

    public void assertInitialized() {
        if (null == this.result) {
            throw new RuntimeException("PublisherBuilder is not yet initialized.");
        }
    }

    public void assertNotInitialized() {
        if (null != this.result) {
            throw new RuntimeException("PublisherBuilder is already initialized.");
        }
    }

    public void initialize(I init) {
        this.assertNotInitialized();
        this.result = this.internalInitialize(init);
        if (null == this.result) {
            throw new RuntimeException("PublisherBuilder initialization failed");
        }
    }

    public void close() {
    }

    protected abstract R internalInitialize(I var1);

    public R getResult() {
        return this.result;
    }

    public boolean isOpened() {
        return null != this.result;
    }
}

