/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.patterns.structure.named;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.patterns.structure.named.NamedItem;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class NameRegistry<E extends NamedItem> {
    protected ConcurrentMap<String, E> namedElements = new ConcurrentHashMap<String, E>();

    public boolean addNamedElement(E elem) {
        String name = elem.getName();
        AssertArgument.assertNotNull(name, "element name");
        return null == this.namedElements.putIfAbsent(name, elem);
    }

    public void assertAddNamedElement(E elem) {
        String name = elem.getName();
        AssertArgument.assertNotNull(name, "element name");
        if (null != this.namedElements.putIfAbsent(name, elem)) {
            throw new IllegalArgumentException("Element with name: \"" + name + "\" already in registry");
        }
    }

    public boolean isNameReserved(String name) {
        return this.namedElements.containsKey(name);
    }

    public E getByName(String name) {
        return (E)((NamedItem)this.namedElements.get(name));
    }

    public E assertGetByName(String name) {
        E e = this.getByName(name);
        if (null == e) {
            throw new RuntimeException("Entity with name \"" + name + "\" doesn't exists.");
        }
        return e;
    }

    public Set<String> getNames() {
        return this.namedElements.keySet();
    }

    public Collection<E> getElements() {
        return this.namedElements.values();
    }
}

